

* FOR FIGURE 2 (and regressions)


* COPY DATA from the the "coeff" parameter from datapreparation.gms IN co2_data_tc.gdx

save "coeffs.dta", replace


rename var1 sector

replace sector = "omn" if sector == "OMN"
replace sector = "isr" if sector == "ISR"

g aggsector = 0

* comparing energy and non energy

g energood = 1 if sector =="gas"
replace energood = 1 if sector =="gdt"
replace energood = 1 if sector =="coa"
replace energood = 1 if sector =="p_c"
replace energood = 1 if sector =="ely"
replace energood = 0 if energood == .


*replace energood = 1 if sector =="oil"


* merge in Co2 coefficients:

replace sector = "ISR" if sector == "isr"
replace sector = "OMN" if sector == "omn"



* gtap 9
*merge m:1 sector using "D:\Dropbox\Conspiring_Tech\CO2 paper\STATA\coeffs_co2_gtap9.dta"



replace sector = "omn" if sector == "OMN"
replace sector = "isr" if sector == "ISR"

* assign to aggregate sector
g aggsectname = ""

replace aggsectname ="TRN" if sector =="atp"
replace aggsectname ="AGR" if sector =="b_t"
replace aggsectname ="AGR" if sector =="c_b"
replace aggsectname ="EIS" if sector =="cmn"
replace aggsectname ="AGR" if sector =="cmt"
replace aggsectname ="EIS" if sector =="cns"
replace aggsectname ="FOS" if sector =="coa"
replace aggsectname ="EIS" if sector =="crp"
replace aggsectname ="FOS" if sector =="oil"
replace aggsectname ="AGR" if sector =="ctl"
replace aggsectname ="SRV" if sector =="dwe"
replace aggsectname ="MAN" if sector =="ele"
replace aggsectname ="FOS" if sector =="ely"
replace aggsectname ="EIS" if sector =="fmp"
replace aggsectname ="AGR" if sector =="frs"
replace aggsectname ="AGR" if sector =="fsh"
replace aggsectname ="FOS" if sector =="gas"
replace aggsectname ="AGR" if sector =="pdr"
replace aggsectname ="AGR" if sector =="wht"
replace aggsectname ="EIS" if sector =="i_s"
replace aggsectname ="SRV" if sector =="isr"
replace aggsectname ="MAN" if sector =="lea"
replace aggsectname ="MAN" if sector =="lum"
replace aggsectname ="AGR" if sector =="mil"
replace aggsectname ="EIS" if sector =="mvh"
replace aggsectname ="EIS" if sector =="nfm"
replace aggsectname ="EIS" if sector =="nmm"
replace aggsectname ="AGR" if sector =="oap"
replace aggsectname ="SRV" if sector =="obs"
replace aggsectname ="AGR" if sector =="ocr"
replace aggsectname ="AGR" if sector =="ofd"
replace aggsectname ="SRV" if sector =="ofi"
replace aggsectname ="MAN" if sector =="ome"
replace aggsectname ="MAN" if sector =="omf"
replace aggsectname ="EIS" if sector =="omn"
replace aggsectname ="AGR" if sector =="omt"
replace aggsectname ="AGR" if sector =="osd"
replace aggsectname ="SRV" if sector =="osg"
replace aggsectname ="MAN" if sector =="otn"
replace aggsectname ="TRN" if sector =="otp"
replace aggsectname ="FOS" if sector =="p_c"
replace aggsectname ="AGR" if sector =="pcr"
replace aggsectname ="AGR" if sector =="pfb"
replace aggsectname ="EIS" if sector =="ppp"
replace aggsectname ="SRV" if sector =="ros"
replace aggsectname ="AGR" if sector =="sgr"
replace aggsectname ="MAN" if sector =="tex"
replace aggsectname ="SRV" if sector =="trd"
replace aggsectname ="AGR" if sector =="v_f"
replace aggsectname ="AGR" if sector =="vol"
replace aggsectname ="MAN" if sector =="wap"
replace aggsectname ="TRN" if sector =="wtp"
replace aggsectname ="SRV" if sector =="wtr"
replace aggsectname ="AGR" if sector =="wol"
replace aggsectname ="AGR" if sector =="rmk"
replace aggsectname ="AGR" if sector =="gro"



* manufsector is defined wrong, fix

replace manufsector = 2 if manufsector ==.
replace manufsector = 0 if manufsector == 1
replace manufsector = 1 if manufsector == 2

replace manufsector = 0 if sector =="pdr"
replace manufsector = 0 if sector =="pcr"
replace manufsector = 0 if sector =="ctl"
replace manufsector = 0 if sector =="osd"
replace manufsector = 0 if sector =="gro"
replace manufsector = 0 if sector =="fsh"
replace manufsector = 0 if sector =="vol"
replace manufsector = 0 if sector =="rmk"
replace manufsector = 0 if sector =="v_f"
replace manufsector = 0 if sector =="sgr"
replace manufsector = 0 if sector =="c_b"
replace manufsector = 0 if sector =="ofd"
replace manufsector = 0 if sector =="b_t"
replace manufsector = 0 if sector =="wht"
replace manufsector = 0 if sector =="pdr"
replace manufsector = 0 if sector =="ocr"
replace manufsector = 0 if sector =="wol"
replace manufsector = 0 if sector =="oap"
replace manufsector = 0 if sector =="frs"
replace manufsector = 0 if sector =="mil"
replace manufsector = 0 if sector =="pfb"
replace manufsector = 0 if sector =="cmt"


* ALTERNATIVE DEF. based on aggregate sector definition

g manufsector2 = 1 if aggsectname =="MAN"
replace manufsector2 = 1 if aggsectname =="EIS"
replace manufsector2 = 0 if sector =="cns"


* merge in names:

 merge m:m sector using "sectornames.dta"

replace shortname = "Refined oil" if sector == "p_c"  
replace shortname = "Natural gas" if sector == "gas"  


 
* with aggregated sectors: 
g aggsect = 1 if shortname =="" 
replace aggsect = 0 if shortname !="" 


replace shortname ="Fossil fuels" if sector =="FOS"
replace shortname ="Agriculture" if sector =="AGR"
replace shortname ="Services" if sector =="SRV"
replace shortname ="Transportation" if sector =="TRN"
replace shortname ="Manufacturing" if sector =="MAN"
replace shortname ="Energy Intensive Industries" if sector =="EIS"


replace longname = "Refined oil" if sector == "p_c" 
replace longname = "All energy" if sector == "all ene" 

g logco2inttotal = log(co2inttotal)
g logghginttotal = log(ghginttotal)
g logseceninttotal = log(seceninttotal)


* FIG2

twoway  (scatter logco2inttotal  incelastmeanshares if aggsect ==0  [aweight=sharefdavg],  mcolor(black) msize(small) msymbol(+)) ///
(scatter logco2inttotal  incelastmeanshares if aggsect ==0  , mlabels(sector) msymbol(none) mlabsize(small) mlabcolor(black))    ///
(lfit logco2inttotal  incelastmeanshares if aggsect ==0  [aweight=sharefdavg] , lcolor(gs10))    ///
(qfit logco2inttotal  incelastmeanshares if aggsect ==0 & incelastmeanshares < 1.5   [aweight=sharefdavg] ,  lpattern(longdash) lcolor(gs10)) ,   ///
 ytitle(Log total CO2 intensity) xtitle(Income elasticity) xline(1, lcolor(black)) xlabel(#7) ylabel(#7) ///
 legend(order(3 "Linear fit" 4 "Quadratic fit") cols(1) ring(0)  position(11)  ) 
graph export "..\figures\Fig2.pdf", as(pdf) replace
graph save "..\figures\Fig2.gph",   replace





* FOR 'SECTORLIST' TABLE
order sector shortname incelastmeanshares totalincelastmeanshares co2intdirect co2inttotal seceninttotal ghginttotal
*sort  spec  incelastmeanshares energood
sort    incelastmeanshares energood




* FOR 'SECT_CORR_AGGREGATE' TABLE
order sector shortname incelastmeanshares totalincelastmeanshares co2intdirect co2inttotal sharetotalco2cons
*sort  spec  energood
sort    energood


graph dot (mean) incelastmeanshares (mean) totalincelastmeanshares if aggsect ==0,  over(shortname, sort(incelastmeanshares) label(labsize(vsmall))) ///
over(energood, sort(incelastmeanshares) descending label(nolabel)) nofill marker(1,  msymbol(Oh) mcolor(black)) marker(2,  msymbol(O) mcolor(navy)) ///
 ytitle(Estimated income elasticities , size(small)) yline(1, lwidth(vthin) lcolor(black))   ylabel(,labsize(small)) ///
 legend(order(1 "Direct income elasticity" 2 "Total income elasticity") size(small) rows(2) position(6) ring(1)) yscale(alt) xsize(12) ysize(17)  ylabel(0(0.2)1.8)
 graph export "..\latex\figures\directVtotal_2ndrev.eps", as(eps) preview(on) replace
 graph export "../latex/figures/directVtotal_2ndrev.eps", as(eps) preview(on) replace
 