

* for Figure 1
* NON-PARAMETRIC FINAL DEMAND ANALYSIS


* copy data from estimates_merged.GDX
* parameter "FOR STATA"


cd "/Users/Justin/Dropbox (Personal)/Conspiring_Tech/CO2 paper/replication package/STATA/"


save fdanalysis, replace


rename var1 spec
rename var2 sector 
rename var3 region


* FD IS PER CAPITA

g lnfd = ln(fd)


g lnpcexp = logpci
g totalfd = totalexp

g lnfittednh = ln(fittednh)
g lnfittedh = ln(fittedh)



 g expshare = fd / exp(lnpcexp)
 
 g expsharefittednh = fittednh / exp(lnpcexp)
 *g expsharefittedh = fittedh / exp(lnpcexp)
 

egen expshare_tot = sum(expshare), by(region)
 
 


* comparing energy and non energy

g energood = 1 if sector =="gas"
replace energood = 1 if sector =="gdt"
replace energood = 1 if sector =="coa"
replace energood = 1 if sector =="p_c"
replace energood = 1 if sector =="ely"
replace energood = 0 if energood == .


*replace energood = 1 if sector =="all ene"

*replace energood = 1 if sector =="oil"


* merge in names:
 merge m:m sector using "sectornames.dta"

* with aggregated sectors: 
g aggsect = 1 if shortname =="" 
replace aggsect = 0 if shortname !="" 


replace shortname ="Fossil fuels" if sector =="FOS"
replace shortname ="Agriculture" if sector =="AGR"
replace shortname ="Services" if sector =="SRV"
replace shortname ="Transportation" if sector =="TRN"
replace shortname ="Manufacturing" if sector =="MAN"
replace shortname ="Energy Intensive Industries" if sector =="EIS"


replace longname = "Refined oil" if sector == "p_c" 
replace longname = "All energy" if sector == "all ene" 


g enesect = longname


* twoway (fpfit incel lnpcexp  if  spec =="estimates_gtap8gas_logweighted_theta4_CLM" & energood ==1 & region!="LUX",  lcolor(navy) lpattern(longdash) mcolor(blue) msize(small) msymbol(+)), by(enesect)

* FIG1
twoway(fpfit incel  lnpcexp  if  spec =="estimates_gtap8gas_logweighted_tc_rall" & energood ==1 & region!="LUX",  lcolor(red) lpattern(solid) mcolor(red) msize(small) msymbol(+)) ///
(fpfit incel lnpcexp  if  spec =="estimates_gtap8gas_logweighted_theta4_CLM" & energood ==1 & region!="LUX",  lcolor(navy) lpattern(longdash) mcolor(blue) msize(small) msymbol(+)) ///
(fpfit incel lnpcexp if spec =="estimates_gtap8gas_logweighted_theta4_CLM_flex_quadratic" & energood ==1 & region!="LUX",  lcolor(orange) lpattern(shortdash) mcolor(orange) msize(small) msymbol(+)) ///
(fpfit incel lnpcexp  if  spec =="estimates_gtap8gas_logweighted_theta4_CLM_flex_shifter" & energood ==1 & region!="LUX",  lcolor(green) lpattern(dash) mcolor(blue) msize(small) msymbol(+)) ///
  ,  legend(order(1 "CRIE"  2 "NH CES" 3 "NH CES quadratic" 4 "NH CES shifter" )   cols(3) ring(0) position(5)  ) yline(1, lcolor(gs10))  xlabel(#7) ///
 ytitle(Estimated income elasticity) xtitle(Log per capita income) by(enesect, compact note("") yrescale) graphregion(color(white))
 graph export "..\figures\FIG1.pdf", as(pdf) preview(on) replace 
 graph save "..\figures\Fig1.gph",   replace
 
 
 



