

* CO2 CONTENT FIGURES


* merge CLM and CRIE files from the estimates folder: co2stats_tc_NH_resprod_15_fitteddem_no AND 
*  co2stats_theta4_NH_CLMquad_resprod_06_fitteddem_no

co2stats_theta4_NH_CLMquad_resprod_06_fitteddem_no_ESTTHETA

* copy 'content' parameter (CO2) from the merged.gdx
* both with fitteddem_no


replace homothpartial = "0" if homothpartial == "Undef"
destring homothpartial, replace





rename var1 spec
rename var2 param
rename var3 region

rename data true


egen logpci_ = max(logpci), by(region)
replace logpci = logpci_
drop logpci_

egen totalfd_ = max(totalfd), by(region)
replace totalfd = totalfd_
drop totalfd_

egen pop_ = max(pop), by(region)
replace pop = pop_
drop pop_

tab spec


save "co2content.dta", replace


	
* FIG3 
twoway (lpolyci  true  logpci if param == "cons - mrio" & region!="LUX" & spec == "NH_resprod_06_fitteddem_no_ESTTHETA", degree(1) lcolor(black) lpattern(longdash) ) ///
 (qfit  true  logpci if param == "cons - mrio" & region!="LUX" & spec == "NH_resprod_06_fitteddem_no_ESTTHETA",  lcolor(black)  ) ///
 (scatter true logpci  if param == "cons - mrio" & region!="MNG" & region!="LUX"  & spec == "NH_resprod_06_fitteddem_no_ESTTHETA",  mcolor(black) msize(small) msymbol(+)) ///
(scatter true logpci if param == "cons - mrio" & region!="MNG" & region!="LUX" & spec == "NH_resprod_06_fitteddem_no_ESTTHETA" , mlabels(region) msymbol(none) mlabsize(vsmall) mlabcolor(black))    ///
, legend(order( 1 "95% CI" 2 "Fit" 3 "Quadratic fit" )  cols(1) ring(0) position(2)  ) xlabel(#7) graphregion(color(white)) ///
 ytitle(Avg. total CO2 content of consumption (kg/$)) xtitle(Log per capita income)
graph export "../figures/Fig3.pdf", as(pdf)  replace
graph save "..\figures\Fig3.gph",   replace




 * FIG5
twoway (lpoly  true   logpci if   param == "imported cons - mrio" &  spec =="NH_resprod_06_fitteddem_no_ESTTHETA" & region !="LUX", degree(1)  lcolor(gs10) lpattern(solid)  )  ///
(lpoly  true   logpci if param == "imported cons - mrio - avg int" &  spec =="NH_resprod_06_fitteddem_no_ESTTHETA" & region !="LUX",   degree(1)  lcolor(black) lpattern(solid)  )   ///
(lpoly  homothpartial   logpci if param == "imported cons - mrio - avg int" &  spec =="NH_resprod_06_fitteddem_no_ESTTHETA" & region !="LUX",   degree(1)  lcolor(green) lpattern(shortdash)  )   ///
 (lpoly  nonhomoth   logpci if param == "imported cons - mrio - avg int" &  spec =="NH_resprod_06_fitteddem_no_ESTTHETA" & region !="LUX",   degree(1)  lcolor(orange) lpattern(longdash)  )   ///
(lpoly  nonhomoth   logpci if param == "imported cons - mrio - avg int" &  spec =="NH_CLMquad_resprod_06_fitteddem_no_ESTTHETA" & region !="LUX" & region !="QAT",  degree(1) lcolor(red) lpattern(dash) )   ///
, legend(order( 1 "Data" 2 "Avg. technologies - Observed consumption" 3 "Avg. technologies - Homothetic consumption" 4 "Avg. technologies - Non-homothetic cons. (CRIE)"  ///
 5 "Avg. technologies - Non-homothetic cons. (NH CES quadratic)" ) size(small) cols(1) ring(0) position(2)  )  ///
 ytitle(Avg. total CO2 content of imported consumption (kg/$)) xtitle(Log per capita income) xlabel(#7)  graphregion(color(white))
 graph export "..\figures\FIG5.pdf", as(pdf) replace
 graph save "..\figures\Fig5.gph",   replace

 


* to truncate graph, necessary to get fitted values
lpoly  true   logpci if param == "cons - mrio" &  spec =="NH_resprod_06_fitteddem_no_ESTTHETA" & region !="LUX",  degree(1)  lcolor(gs10) lpattern(solid) gen(true_lpoly) at(logpci)

 
* FIG4
twoway (lpoly  true_lpoly   logpci if true_lpoly>0.4 &  param == "cons - mrio" &  spec =="NH_resprod_06_fitteddem_no_ESTTHETA" & region !="LUX", degree(1)  lcolor(gs10) lpattern(solid)  )   ///
(lpoly  true   logpci if param == "cons - mrio - avg int" &  spec =="NH_resprod_06_fitteddem_no_ESTTHETA" & region !="LUX",   degree(1)  lcolor(black) lpattern(solid)  )   ///
(lpoly  homothpartial   logpci if param == "cons - mrio - avg int" &  spec =="NH_resprod_06_fitteddem_no_ESTTHETA" & region !="LUX",   degree(1)  lcolor(green) lpattern(shortdash)  )   ///
 (lpoly  nonhomoth   logpci if param == "cons - mrio - avg int" &  spec =="NH_resprod_06_fitteddem_no_ESTTHETA" & region !="LUX",   degree(1)  lcolor(orange) lpattern(longdash)  )   ///
(lpoly  nonhomoth   logpci if param == "cons - mrio - avg int" &  spec =="NH_CLMquad_resprod_06_fitteddem_no_ESTTHETA" & region !="LUX" & region !="QAT",  degree(1) lcolor(red) lpattern(dash) )   ///
, legend(order( 1 "Data" 2 "Avg. technologies - Observed consumption" 3 "Avg. technologies - Homothetic consumption" 4 "Avg. technologies - Non-homothetic cons. (CRIE)"  ///
 5 "Avg. technologies - Non-homothetic cons. (NH CES quadratic)" ) size(small) cols(1) ring(0) position(7)  )  ///
 ytitle(Avg. total CO2 content of consumption (kg/$)) xtitle(Log per capita income) xlabel(#7) graphregion(color(white))
 graph export "..\figures\Fig4.pdf", as(pdf) replace
graph save "..\figures\Fig4.gph",   replace  

 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
* FOR APPENDIX: COMPARING TO THE OTHER CLMS:
twoway (lpoly  true   logpci if param == "cons - mrio - avg int" &  spec =="co2stats_tc_NH_resprod_15_fitteddem_no" & region !="LUX",   degree(1)  lcolor(black) lpattern(solid)  )   ///
 (lpoly  nonhomoth   logpci if param == "cons - mrio - avg int" &  spec =="co2stats_tc_NH_resprod_15_fitteddem_no" & region !="LUX",   degree(1)  lcolor(orange) lpattern(longdash)  )   ///
(lpoly  nonhomoth   logpci if param == "cons - mrio - avg int" &  spec =="co2stats_theta4_NH_CLM_resprod_06_fitteddem_no" & region !="LUX" & region !="QAT",  degree(1)  lcolor(navy) lpattern(shortdash) )   ///
(lpoly  nonhomoth   logpci if param == "cons - mrio - avg int" &  spec =="co2stats_theta4_NH_CLMshift_resprod_06_fitteddem_no" & region !="LUX" & region !="QAT",  degree(1) lcolor(purple) lpattern(longdash_shortdash) )   ///
(lpoly  nonhomoth   logpci if param == "cons - mrio - avg int" &  spec =="co2stats_theta4_NH_CLMquad_resprod_06_fitteddem_no" & region !="LUX" & region !="QAT",  degree(1) lcolor(red) lpattern(dash) )   ///
, legend(order( 1 "Avg. technologies - Observed consumption" 2 "Avg. technologies - CRIE" 3 "Avg. technologies - NH CES log-linear" ///
4 "Avg. technologies - NH CES shifter" 5 "Avg. technologies - NH CES quadratic") size(small)  cols(1) ring(0) position(7)  )  ///
 ytitle(Avg. total CO2 content of consumption (kg/$)) xtitle(Log per capita expenditure) xlabel(#7)
  graph export "..\latex\figures\PAPR_summary_mrio_2ndrev_clm_comp.eps", as(eps) preview(on) replace
 
