:###################################

: Per capita income, consumption patterns, and CO2 emissions

: Journal of the Association of Environmental and Resource Economists

: Justin Caron and Thibault Fally

: April 2021

:###################################

: BATCH FILE DESCRIBING THE ESTIMATION AND SIMULATION WORKFLOW

: NOTE: ONLY THE LINES REQUIRED TO GENERATE RESULTS IN MAIN TEXT ARE UNCOMMENTED 


: 1 - GRAVITY AND DEMAND SYSTEM ESTIMATION 

: 1.1 - estimate gravity equations 

gams gravity.gms

: 1.2 - first, estimate demand system (this does both H and NH for each spec)


: Non-Homomthetic CES (CLM) preferences
: note: there are different files here because good starting values are required 

:gams demand_clm_t4.gms
gams demand_clm_flex_quadratic_t4.gms
:gams demand_clm_flex_shifter_t4.gms

: output: estimates/gtap8gas_logweighted_theta4_CLM_flex_XXX.gdx

: CRIE preferences
gams demand.gms --spec=theta4 --objective=logweighted  
gams demand.gms --spec=tc --objective=logweighted  
:gams demand.gms --spec=theta8 --objective=logweighted  

:  output: estimates\estimates_gtap8gas_logweighted_tc_rall.gdx

: 2 - PREPARE DATA FOR CO2 REPORTING
: computes total coefficients and total income elasticity using demand estimates
	
gams datapreparation.gms --demandest=theta4 --beta=avg 
gams datapreparation.gms --demandest=tc  --beta=avg 

: for reporting, with country-specific input-output coefficients
gams datapreparation.gms --demandest=theta4 --beta=cs 
gams datapreparation.gms --demandest=tc --beta=cs 

:  output: estimates/co2_data_%demandest%.gdx

: robustness check with GTAP9 (files available upon request)
::gams demand_gtap9.gms --spec=tc --objective=logweighted  
::gams datapreparation_gtap9.gms --demandest=tc 


: 3 - RUN SIMULATIONS

: 3.1 simulations require first computing fitted production from fitted demand
: CRIE:
gams CF_compute_fittedprod_shares.gms --demandest=tc --spec=NH
: gams CF_compute_fittedprod_shares.gms --demandest=theta4 --spec=NH
: gams CF_compute_fittedprod_shares.gms --demandest=theta8 --spec=NH

: NH CES (CLM)
:gams CF_compute_fittedprod_shares.gms --demandest=theta4 --spec=NH_CLMshift
gams CF_compute_fittedprod_shares.gms --demandest=theta4 --spec=NH_CLMquad
:gams CF_compute_fittedprod_shares.gms --demandest=theta4 --spec=NH_CLM

: output 'estimates/fitted_prod_shares_%spec%_%demandest%.gdx'

: 3.2 run simulations

: declare supply side specification: noresprod, resprod, resprod_06, resprod_15,  resprod_50
: benchmark case is resprod_06, which represents 0.75 supply elasticity

: CRIE preferences
gams cf_co2_nh.gms --demandest=tc --spec=NH  --prodspec=resprod_06
:gams cf_co2_nh.gms --demandest=tc --spec=NH  --prodspec=resprod_15 
:gams cf_co2_nh.gms --demandest=tc --spec=NH  --prodspec=resprod_50
:gams cf_co2_nh.gms --demandest=tc --spec=NH  --prodspec=noresprod
d:gams cf_co2_nh.gms --demandest=tc --spec=H  --prodspec=noresprod

: theta4 (not used in paper)
::gams cf_co2_nh.gms --demandest=theta4 --spec=NH  --prodspec=resprod_06

: output results/CFresults_co2_%spec%_%demandest%_%prodspec%.gdx'

: Non-homothetic CES - CLM  

: quadratic
gams CF_co2_NH_CLM_flex.gms --demandest=theta4 --spec=NH_CLMquad  --prodspec=resprod_06

: standard CLM
:gams CF_co2_NH_CLM_flex.gms --demandest=theta4 --spec=NH_CLM  --prodspec=resprod_06

:shifter
:gams CF_co2_NH_CLM_flex.gms --demandest=theta4 --spec=NH_CLMshift  --prodspec=resprod_06

: 3.3 robustness checks

: sensitivity to theta
:gams cf_co2_nh.gms --demandest=theta8 --spec=NH  --prodspec=resprod_06

: higher elasticity for gas:
:gams cf_co2_nh.gms --demandest=tc --spec=NH  --prodspec=resprod_06_gas15

: with observed gdp growth
:gams cf_co2_nh_obsgdp.gms --demandest=tc --spec=NH  --prodspec=resprod_06
: homothetic:

: with observed gdp growth - AND NO RESOURCE PROD GROWTH
:gams cf_co2_nh_obsgdp.gms --demandest=tc --spec=NH  --prodspec=noresprod
: homothetic:
:gams cf_co2_nh_obsgdp.gms --demandest=tc --spec=H  --prodspec=noresprod

: 10pct shock
: use same file BUT CHANGE income shock manually
:gams cf_co2_nh.gms --demandest=tc --spec=NH  --prodspec=resprod_06


: 4 - COMPUTE REPORTING PARAMETERS AND STATISTICS

: co2_estimations.gms loads demand estimates, coefficients from datapreparation and simulation results
: this file can do both NH CES and CRIE:

: NOTE: for the "content" computations, set fitdem=no
: to compute the "simulation" results, set fitdem= yes

: 4.1 compiling simulation results

: CRIE
gams co2_estimations.gms  --demandest=tc --spec=NH  --prodspec=resprod_06  --fitdem=yes 

: output: results/co2stats_%demandest%_%spec%_%prodspec%_fitteddem_%fitdem%_ESTTHETA.gdx

: NH CES QUADRATIC
gams co2_estimations.gms  --demandest=theta4 --spec=NH_CLMquad  --prodspec=resprod_06  --fitdem=yes

: other runs:

: sensitivity to theta
::gams co2_estimations.gms  --demandest=theta8 --spec=NH  --prodspec=resprod_06  --fitdem=yes

:gams co2_estimations.gms  --demandest=tc --spec=NH  --prodspec=resprod_06_gas15  --fitdem=yes
: 10pct shock -- need to go change the gdxin in co2_estimations -- SEARCH FOR _10pctshock IN THAT FILE AND MODIFY
:gams co2_estimations.gms  --demandest=tc --spec=NH  --prodspec=resprod_06  --fitdem=yes

:   CFresults_co2_NH_tc_resprod_06_fitteddem_obsgdp
:gams co2_estimations.gms  --demandest=tc --spec=NH  --prodspec=resprod_06  --fitdem=yes
: same, homothetic:
:gams co2_estimations.gms  --demandest=tc --spec=H  --prodspec=resprod_06  --fitdem=yes

: same, noresprod 
:gams co2_estimations.gms  --demandest=tc --spec=NH  --prodspec=noresprod  --fitdem=yes
: same, homothetic:
:gams co2_estimations.gms  --demandest=tc --spec=H  --prodspec=noresprod  --fitdem=yes


:gams co2_estimations.gms  --demandest=tc --spec=NH  --prodspec=resprod_15  --fitdem=yes
:gams co2_estimations.gms  --demandest=tc --spec=NH  --prodspec=resprod_50  --fitdem=yes

:gams co2_estimations.gms  --demandest=tc --spec=NH  --prodspec=noresprod  --fitdem=yes
:gams co2_estimations.gms  --demandest=tc --spec=H  --prodspec=noresprod  --fitdem=yes

:gams co2_estimations.gms  --demandest=theta4 --spec=NH_CLMshift  --prodspec=resprod_06  --fitdem=yes
:gams co2_estimations.gms  --demandest=theta4 --spec=NH_CLM  --prodspec=resprod_06  --fitdem=yes


: 4.2 for `co2 content' analysis:

gams co2_estimations.gms  --demandest=tc --spec=NH  --prodspec=resprod_06  --fitdem=no
:gams co2_estimations.gms  --demandest=theta4 --spec=NH_CLMshift  --prodspec=resprod_06  --fitdem=no
gams co2_estimations.gms  --demandest=theta4 --spec=NH_CLMquad  --prodspec=resprod_06  --fitdem=no
:gams co2_estimations.gms  --demandest=theta4 --spec=NH_CLM  --prodspec=resprod_06  --fitdem=no

: output 'estimates/co2stats_%demandest%_%spec%_%prodspec%.gdx'
: and 'estimates/chg_energy_co2_%demandest%/%spec%_%prodspec%.gdx', chg_energy_co2;
: use the later to combine estimates for graphing in stata


cd results/simulationresults_tomerge/
gdxmerge *.gdx
cd..
cd..

:end