

* ------------------------------------------------------
* Per Capita Income and the Demand for Skills
* Journal of International Economics

* Justin Caron, Thibault Fally and James Markusen

* December 2019
* ------------------------------------------------------

set varabbrev off, permanently

* load data from GAMS:

* first, create a file  logpci and pop and shocks from reporting "final"
* from the file RESULTS/TC/CF_Skill_prod_yes_trade_yes_NH.gdx
* copy the REPORTING parameter, chosing the FINAL iteration (row = countries, cols = params)
rename var1 region	
save "reporting_NH.dta", replace
clear

* for GROWTH-ONLY decompositions, create file with PE approximations
* copy the DECOMPOSITION parameter from the RESULTS/TC/CF_Skill_prod_load_trade_no_NH.GDX file
* (row = countries, cols = params)
rename var1 region
drop logpci
save "growthapprox_NH.dta", replace
clear

* for TRADE-ONLY decompositions, create file with decomp
* copy the LOG_CHG_SKILLPREM_APPROX parameter from the RESULTS/TC/CF_Skill_prod_no_trade_load_NH.GDX file
* (row = countries, cols = params) (chose "T1" or any other)
rename var1 region	
rename noapprox noapprox_NH
rename direct_feb2019 direct_feb2019_NH
rename mr_feb2019 mr_feb2019_NH
rename lambda lambda_NH
rename p2 p2_NH
rename io io_NH
save "tradedecomp_NH.dta", replace
clear
* then the same for homothetic preferences
* copy the LOG_CHG_SKILLPREM_APPROX parameter from the RESULTS/TC/CF_Skill_prod_no_trade_load_H.GDX file
* (row = countries, cols = params) (chose "T1" or any other)
rename var1 region	
rename noapprox noapprox_H
rename direct_feb2019 direct_feb2019_H 
rename mr_feb2019 mr_feb2019_H 
rename lambda lambda_H 
rename p2 p2_H 
rename io io_H 
save "tradedecomp_H.dta", replace
clear

* for robustness checks:
* copy theta4 results
* from RESULTS/SPESTIMATES_TOMERGE_theta4/MERGED.GDX file
* copy the SKILLPREMIUM parameter (rows = countries, cols = specifications)
rename var1 region
rename cf_prod_load_trade_no_h cf_prod_load_trade_no_h_t4
rename cf_prod_load_trade_no_nh cf_prod_load_trade_no_nh_t4
rename cf_prod_no_trade_load_h cf_prod_no_trade_load_h_t4
rename cf_prod_no_trade_load_nh cf_prod_no_trade_load_nh_t4
rename cf_prod_yes_trade_yes_h cf_prod_yes_trade_yes_h_t4
rename cf_prod_yes_trade_yes_nh cf_prod_yes_trade_yes_nh_t4
save "skillpremium_t4.dta", replace
clear

* copy Comin et al 2016 CLM results
* from RESULTS/SPESTIMATES_TOMERGE_theta4/MERGED.GDX file
* copy the SKILLPREMIUM parameter (rows = countries, cols = specifications)
rename var1 region
save "skillpremium_clm.dta", replace
clear

* copy country-specific input CSbeta results
* from RESULTS/SPESTIMATES_TOMERGE_csbeta/MERGED.GDX file
* copy the SKILLPREMIUM parameter (rows = countries, cols = specifications)
rename var1 region
rename unif_prod_yes_trade_yes_h unif_prod_yes_trade_yes_h_csbeta
rename unif_prod_yes_trade_yes_nh unif_prod_yes_trade_yes_nhcsbeta
save "skillpremium_csbeta.dta", replace
clear


* ---------------------------------------------------------------
* START HERE

* then, need to merge all results in the SPestimates_tomerge_tc subfolder (manually or with batch file)
* this creates the RESULTS/SPESTIMATES_TOMERGE_TC/MERGED.GDX file
* copy the SKILLPREMIUM parameter (rows = countries, cols = specifications)
rename var1 region
merge 1:1 region using "reporting_NH.dta"
drop _merge
merge 1:1 region using "growthapprox_NH.dta"
drop _merge
merge 1:1 region using "tradedecomp_NH.dta"
drop _merge
merge 1:1 region using "tradedecomp_H.dta"
drop _merge
merge 1:1 region using "skillpremium_t4.dta"
drop _merge
merge 1:1 region using "skillpremium_clm.dta"
drop _merge
merge 1:1 region using "skillpremium_csbeta.dta"
drop _merge


	
rename tradecost tradecost_NH 
* here, need to remember that prod wast normalized : check target_rescale_factor
rename prodshock prodshock_NH

 
replace region = upper(region)	
save "skillpremium.dta", replace	

g pci = exp(logpci)

rename  cf_prod_yes_trade_yes_nh unified_1995_2009
rename cf_prod_yes_trade_yes_h  unified_1995_2009_H
g unified_1995_2009_NH_H_diff = unified_1995_2009 - unified_1995_2009_H

rename  cf_prod_load_trade_no_nh growthonly_1995_2009
rename cf_prod_load_trade_no_h growthonly_1995_2009_H
g growthonly_1995_2009_NH_H_diff  = growthonly_1995_2009 - growthonly_1995_2009_H

rename approxratio approx
rename justfdapproxratio justfd

rename cf_prod_no_trade_load_nh tradeonly_1995_2009
rename cf_prod_no_trade_load_h tradeonly_1995_2009_H
g tradeonly_1995_2009_NH_H_diff  = tradeonly_1995_2009 - tradeonly_1995_2009_H 
 
	
* --- 1 UNIFIED MODEL
* the unified = growth + trade counterfactual


* some numbers for paper:
tab unified_1995_2009 if region =="VNM"
tab unified_1995_2009 if region =="CHN"
tab unified_1995_2009 if region =="IND"
tab unified_1995_2009 if region =="BRA"
tab unified_1995_2009 if region =="MEX"
tab unified_1995_2009 if region =="USA"
tab unified_1995_2009 if region =="RUS"

* world bank 1997 definition of 'low income' is 785$
count if pci < 785
* that's 11 countries.
sum unified_1995_2009 if pci < 785
sum unified_1995_2009 if pci > 785
* high income is about 8500

* Figure 2: The effect of growth and trade on the skill premium.
* Skill premium increase: full counterfactual (1995-2009)
twoway (scatter unified_1995_2009_H logpci if region!="ZWE", yline(0, lcolor(gs8)) mlabsize(vsmall) mcolor(navy) msize(small) msymb(triangle) mlabel(region)) ///
(scatter unified_1995_2009 logpci if region!="ZWE", yline(0, lcolor(gs8)) msize(small) mcolor(maroon) mlabcolor(maroon) mlabsize(vsmall)  mlabel(region)) ///
(lfit unified_1995_2009_H logpci, lcolor(navy) lpattern(longdash)) ///
(lfit unified_1995_2009 logpci,  lcolor(maroon)), ///	
ytitle("Skill premium increase", size(small)) xtitle("Log per capita expenditures", size(small)) title("") ///
legend(label(1 "Homothetic preferences")  label(2 "Non-homothetic preferences") label(3 "Linear Fit") label(4 "Linear Fit") size(small)) ///
graphregion(lcolor(white) fcolor(white)) xlabel(, labsize(small)) ylabel(, labsize(small))  
graph export "figures\2_SP_unified_growthandtrade_95_09_NH_H.pdf", as(pdf) replace

* ZWE values
tab unified_1995_2009  if region=="ZWE"
tab unified_1995_2009_H  if region=="ZWE"
		
* --- 2 GROWTH ONLY COUNTERFACTUAL

tab growthonly_1995_2009 if region =="CHN"
tab growthonly_1995_2009 if region =="IND"
tab growthonly_1995_2009 if region =="BRA"
tab growthonly_1995_2009 if region =="MEX"
tab growthonly_1995_2009 if region =="USA"

sum growthonly_1995_2009 if pci < 785
sum growthonly_1995_2009 if pci > 785


* now the homoth
*drop growthonly_1995_2009_H

twoway (scatter growthonly_1995_2009_H logpci, mlabel(region)  yline(1)) (lfit growthonly_1995_2009_H logpci)
* small effect. 

* Figure 3a: Decomposition into the growth and trade channels.
twoway (scatter growthonly_1995_2009_H logpci, yline(0, lcolor(gs8)) mlabsize(vsmall) mcolor(navy) msize(small) msymb(triangle) mlabel(region)) ///
(scatter growthonly_1995_2009 logpci, yline(0, lcolor(gs8)) msize(small) mcolor(maroon) mlabcolor(maroon) mlabsize(vsmall)  mlabel(region)) ///
(lfit growthonly_1995_2009_H logpci, lcolor(navy) lpattern(longdash)) ///
(lfit growthonly_1995_2009 logpci,  lcolor(maroon)), ///
ytitle("Skill premium increase", size(small)) xtitle("Log per capita expenditures", size(small)) title("") ///
legend(label(1 "Homothetic preferences")  label(2 "Non-homothetic preferences") label(3 "Linear Fit") label(4 "Linear Fit") size(small)) ///
graphregion(lcolor(white) fcolor(white)) xlabel(, labsize(small)) ylabel(, labsize(small)) 
graph export "figures\3_SP_unified_growthonly_95_09_NH_H.pdf", as(pdf) replace 


* --- 2.1 APPROXIMATIONS.

replace approx = approx -1
replace justfd = justfd -1

* rescale
replace approx = approx *10
replace justfd = justfd *10
replace avincelastwithio = avincelastwithio *10

* need to divide these by rho tilde
replace approx = approx	/ rhotilde
replace justfd = justfd / rhotilde
replace avincelastwithio = avincelastwithio / rhotilde

g approx_elast = approx / ((prodshock_NH -1)*10)

* regressions for text
reg justfd growthonly_1995_2009 if region !="ZWE" & region !="BWA", robust
reg approx  growthonly_1995_2009 if region !="ZWE" & region !="BWA", robust


*Figure 4: Growth channel. Closed-economy approximations with and without intermediate good (IO)
*linkages and comparison to general equilibrium estimates.
twoway (scatter  growthonly_1995_2009_NH_H_diff logpci ,  yline(0, lcolor(gs8)) mcolor(maroon) mlabsize(vsmall) msize(small)  mlabcolor(maroon)) ///
(lfit  growthonly_1995_2009_NH_H_diff logpci, lpattern(solid) lcolor(maroon)) ///
(scatter  approx logpci , yline(0, lcolor(gs8))   mcolor(black) mlabsize(vsmall) msymbol(Sh)  msize(small) mlabcolor(navy)) ///
(lfit  approx logpci , lpattern(longdash) lcolor(black)) ///
(scatter  justfd logpci , yline(0, lcolor(gs8))   mcolor(navy) mlabsize(vsmall) msymbol(Oh)  msize(small) mlabcolor(navy)) ///
(lfit  justfd logpci , lpattern(shortdash) lcolor(navy)), ///
ytitle("Skill premium increase", size(small)) xtitle("Log per capita expenditures", size(small)) title("") ///
graphregion(lcolor(white) fcolor(white)) legend( size(small) col(2 ) label(1 "General equilibrium counterfactual (non-homoth. to homoth. difference)") label(2 "")  label(3 "Closed economy approximation") ///
label(4 "") label(5 "Closed economy approximation without IO linkages") label(6 "") ) xlabel(, labsize(small)) ylabel(, labsize(small))
graph export "figures\4_closed_vs_open_vs_nolinkage_revision_diff_versuspci.pdf", as(pdf) replace



* Figure 5: Growth channel. Closed-economy approximations. Effect of heterogenous growth rates and
* effect of cross-country variations in income elasticity within sectors.
twoway (scatter  approx logpci ,  yline(0, lcolor(gs8)) mcolor(black) mlabsize(vsmall)  msymbol(Sh) msize(small)  mlabcolor(black)) ///
(scatter  approx_elast logpci if approx_elast < 0.2, yline(0, lcolor(gs8))   mcolor(maroon) mlabsize(vsmall)  msymbol(D) msize(small) mlabcolor(maroon)) ///
(scatter  avincelastwithio logpci  if region!="LKA", yline(0, lcolor(gs8))   mcolor(navy) mlabsize(vsmall) msize(small)  msymbol(dh)  mlabcolor(navy)) ///
(lfit  approx logpci, lpattern(solid) lcolor(black)) ///
(lfit  approx_elast logpci  if approx_elast < 0.2, lpattern(shortdash) lcolor(maroon)) ///
(lfit  avincelastwithio logpci  if region!="LKA", lpattern(longdash) lcolor(navy)), ///
ytitle("Skill premium increase", size(small)) xtitle("Log per capita expenditures", size(small)) title("") ///
graphregion(lcolor(white) fcolor(white)) legend(order(1 4 2 5 3 6 ) size(small) col(2 ) label(1 "Closed economy approximation") label(4 "")  label(2 "   - with uniform growth rates") ///
label(5 "") label(3 "   - using mean income elasticity per sector") label(6 "") ///
 ) xlabel(, labsize(small)) ylabel(, labsize(small))
graph export "figures\5_approx_decomp_simpler_secondrevision.pdf", as(pdf) replace


* --- 3 TRADE-ONLY COUNTERFACTUAL



* graph comparing the two
twoway (scatter tradeonly_1995_2009_H logpci, yline(0, lcolor(black)) mlabsize(vsmall) mcolor(navy) msize(small) msymb(triangle) mlabel(region)) ///
(scatter tradeonly_1995_2009 logpci, yline(0, lcolor(gs8)) msize(small) mcolor(maroon) mlabcolor(maroon) mlabsize(vsmall)  mlabel(region)) ///
(lfit tradeonly_1995_2009_H logpci, lcolor(navy) lpattern(longdash)) ///
(lfit tradeonly_1995_2009 logpci,  lcolor(maroon)), ///
ytitle("Skill premium increase", size(small)) xtitle("Log per capita expenditures", size(small)) title("") ///
legend(label(1 "Homothetic preferences")  label(2 "Non-homothetic pref.") label(3 "Linear Fit") label(4 "Linear Fit") size(small)) ///
graphregion(lcolor(white) fcolor(white)) xlabel(, labsize(small)) ylabel(, labsize(small)) 
graph export "D:\Dropbox\Conspiring_Tech\PCI and skill premium\figures_2019revision\SP_unified_tradeonly_95_09_NH_H.pdf", as(pdf) replace


* graph comparing the two -- DROPPING ZWE AND VNM
twoway (scatter tradeonly_1995_2009_H logpci if region !="ZWE" & region !="VNM", yline(0, lcolor(black)) mlabsize(vsmall) mcolor(navy) msize(small) msymb(triangle) mlabel(region)) ///
(scatter tradeonly_1995_2009 logpci if region !="ZWE" & region !="VNM", yline(0, lcolor(gs8)) msize(small) mcolor(maroon) mlabcolor(maroon) mlabsize(vsmall)  mlabel(region)) ///
(lfit tradeonly_1995_2009_H logpci if region !="ZWE" & region !="VNM" , lcolor(navy) lpattern(longdash)) ///
(lfit tradeonly_1995_2009 logpci if region !="ZWE" & region !="VNM",  lcolor(maroon)), ///
ytitle("Skill premium increase", size(small)) xtitle("Log per capita expenditures", size(small)) title("") ///
legend(label(1 "Homothetic preferences")  label(2 "Non-homothetic pref.") label(3 "Linear Fit") label(4 "Linear Fit") size(small)) ///
graphregion(lcolor(white) fcolor(white)) xlabel(, labsize(small)) ylabel(, labsize(small)) 
graph export "D:\Dropbox\Conspiring_Tech\PCI and skill premium\figures_2019revision\SP_unified_tradeonly_95_09_NH_H_nooutliers.pdf", as(pdf) replace

*  DIFF LABELS FOR COUNTRIES WITH REDUCTIONS IN OPENESS, AND NOT INCLUDING THESE COUNTRIES IN THE REGRESSION LINE
twoway (scatter tradeonly_1995_2009_H logpci if region !="ZWE" & region !="VNM"  & tradecost_NH < 1, yline(0, lcolor(black)) mlabsize(vsmall) mcolor(navy) msize(small) msymb(t) mlabel(region)) ///
(scatter tradeonly_1995_2009 logpci if region !="ZWE" & region !="VNM" & tradecost_NH < 1, yline(0, lcolor(gs8)) msize(small) mcolor(maroon) mlabcolor(maroon)  msymb(O) mlabsize(vsmall)  mlabel(region)) ///
(scatter tradeonly_1995_2009_H logpci if region !="ZWE" & region !="VNM"  & tradecost_NH > 1, yline(0, lcolor(black)) mlabsize(vsmall)  msymb(th) mcolor(navy) msize(small) mlabcolor(navy)   mlabel(region)) ///
(scatter tradeonly_1995_2009 logpci if region !="ZWE" & region !="VNM" & tradecost_NH > 1, yline(0, lcolor(gs8)) msize(small) mcolor(maroon) msymb(Oh) mlabcolor(maroon) mlabsize(vsmall)  mlabel(region)) ///
(lfit tradeonly_1995_2009_H logpci if region !="ZWE" & region !="VNM" & tradecost_NH < 1, lcolor(navy) lpattern(longdash)) ///
(lfit tradeonly_1995_2009 logpci if region !="ZWE" & region !="VNM" & tradecost_NH < 1,  lcolor(maroon)), ///
ytitle("Skill premium increase", size(small)) xtitle("Log per capita expenditures", size(small)) title("") ///
legend(label(1 "Homothetic preferences")  label(2 "Non-homothetic pref.") label(3 "(trade cost increase)") label(4 "(trade cost increase)") label(5 "Linear Fit") label(6 "Linear Fit") size(small)) ///
graphregion(lcolor(white) fcolor(white)) xlabel(, labsize(small)) ylabel(, labsize(small)) 
graph export "D:\Dropbox\Conspiring_Tech\PCI and skill premium\figures_2019revision\SP_unified_tradeonly_95_09_NH_H_tradecostlabels.pdf", as(pdf) replace

* NOT INCLUDING COUNTRIES with trade cost increases -- FOR SIDE-BY-SIDE
twoway (scatter tradeonly_1995_2009_H logpci if region !="ZWE" & region !="VNM"  & tradecost_NH < 1, yline(0, lcolor(black)) mlabsize(vsmall) mcolor(navy) msize(small) msymb(t) mlabel(region)) ///
(lfit tradeonly_1995_2009_H logpci if region !="ZWE" & region !="VNM" & tradecost_NH < 1, lcolor(navy) lpattern(longdash)) ///
(scatter tradeonly_1995_2009 logpci if region !="ZWE" & region !="VNM" & tradecost_NH < 1, yline(0, lcolor(gs8)) msize(small) mcolor(maroon) mlabcolor(maroon)  msymb(O) mlabsize(vsmall)  mlabel(region)) ///
(lfit tradeonly_1995_2009 logpci if region !="ZWE" & region !="VNM" & tradecost_NH < 1,  lcolor(maroon)), ///
ytitle("Skill premium increase") xtitle("Log per capita expenditures") title("") ///
legend(label(1 "Homothetic preferences")  label(3 "Non-homothetic pref.") label(2 "") label(4 "") col(2) ring(0) pos(5) size(small) ) ///
graphregion(lcolor(white) fcolor(white)) xlabel(, labsize(small)) ylabel(, labsize(small))  xsize(11) ysize(12)
graph export "D:\Dropbox\Conspiring_Tech\PCI and skill premium\figures_2019revision\SP_unified_tradeonly_95_09_NH_H_onlytradecostreduc.pdf", as(pdf) replace

*  Figure 3b: Decomposition into the growth and trade channels.
twoway (scatter tradeonly_1995_2009_H logpci if region !="ZWE" & region !="VNM"  & tradecost_NH < 1,  yline(0, lcolor(gs8)) mlabsize(vsmall) mcolor(navy) msize(small) msymb(triangle) mlabel(region)) ///
(scatter tradeonly_1995_2009 logpci if region !="ZWE" & region !="VNM" & tradecost_NH < 1 , yline(0, lcolor(gs8)) msize(small) mcolor(maroon) mlabcolor(maroon) mlabsize(vsmall)  mlabel(region)) ///
(lfit tradeonly_1995_2009_H logpci if region !="ZWE" & region !="VNM" & tradecost_NH < 1, lcolor(navy) lpattern(longdash)) ///
(lfit tradeonly_1995_2009 logpci if region !="ZWE" & region !="VNM" & tradecost_NH < 1,  lcolor(maroon)), ///
ytitle("Skill premium increase", size(small)) xtitle("Log per capita expenditures", size(small)) title("") ///
legend(label(1 "Homothetic preferences")  label(2 "Non-homothetic preferences") label(3 "Linear Fit") label(4 "Linear Fit") size(small)) ///
graphregion(lcolor(white) fcolor(white)) xlabel(, labsize(small)) ylabel(, labsize(small))  
graph export "figures\3b_SP_unified_tradeonly_95_09_NH_H_onlytradecostreduc_v.pdf", as(pdf) replace

tab tradeonly_1995_2009_H  if region =="ZWE"
tab tradeonly_1995_2009  if region =="ZWE"
tab tradeonly_1995_2009_H  if region =="VNM"
tab tradeonly_1995_2009  if region =="VNM"

* some numbers for text:

tab tradeonly_1995_2009_NH_H_diff if region =="CHN"
tab tradeonly_1995_2009_NH_H_diff if region =="IND"
tab tradeonly_1995_2009_NH_H_diff if region =="BRA"
tab tradeonly_1995_2009_NH_H_diff if region =="MEX"
tab tradeonly_1995_2009_NH_H_diff if region =="USA"
tab tradeonly_1995_2009_NH_H_diff if region =="RUS"

sum tradeonly_1995_2009_NH_H_diff if pci < 785 &  region !="ZWE" & region !="JPN"  & tradecost_NH < 1
sum tradeonly_1995_2009_NH_H_diff if pci > 785 &  region !="ZWE" & region !="JPN"  & tradecost_NH < 1


* * --- 4 INTERACTIONS: are the two mechs seperable?

g sum_growthandtrade_1995_2009 = growthonly_1995_2009 + tradeonly_1995_2009
g sum_growthandtrade_1995_2009_H = growthonly_1995_2009_H + tradeonly_1995_2009_H

* Figure A.8: 1995 to 2010 changes in the skill premium: simultaneous changes in productivity and trade,
* decomposition into growth and trade, comparison to recomposed growth + trade estimates.
twoway (scatter  unified_1995_2009 logpci if unified_1995_2009  > -0.1, yline(0, lcolor(gs8))  mcolor(black) mlabsize(vsmall) msize(small) msymbol(Sh)  mlabcolor(navy)) ///
(scatter  growthonly_1995_2009 logpci if growthonly_1995_2009  > -0.1, yline(0, lcolor(gs8))   mcolor(maroon) mlabsize(vsmall)  msymbol(D) msize(small) mlabcolor(maroon)) ///
(scatter  tradeonly_1995_2009 logpci if tradeonly_1995_2009  > -0.1, yline(0, lcolor(gs8))   mcolor(navy) mlabsize(vsmall) msize(small)  msymbol(triangle)  mlabcolor(navy)) ///
(scatter  sum_growthandtrade_1995_2009 logpci if sum_growthandtrade_1995_2009  > -0.1, yline(0, lcolor(gs8))   mcolor(green) mlabsize(vsmall) msize(small)  msymbol(Oh)  mlabcolor(green)) ///
(lfit  unified_1995_2009 logpci, lpattern(solid) lcolor(black)) ///
(lfit  growthonly_1995_2009 logpci if region !="ROM" & region !="LKA", lpattern(shortdash) lcolor(maroon)) ///
(lfit  tradeonly_1995_2009 logpci, lpattern(longdash) lcolor(navy)) ///
(lfit  sum_growthandtrade_1995_2009 logpci, lpattern(dash) lcolor(green)), ///
ytitle("Skill premium increase", size(small)) xtitle("Log per capita expenditures", size(small)) title("") ///
graphregion(lcolor(white) fcolor(white)) legend( size(small) col(4 ) order(1 5 2 6 4 8 3 7 ) label(1 "Growth and trade: simultaneous solve") label(5 "")  label(2 "Growth only") ///
label(6 "") label(3 "Trade only ") label(7 "") label(4 "Growth and trade: seperate solve (recomposed) ") label(8 "")  ) xlabel(, labsize(small)) ylabel(, labsize(small)) ///
ylabel(-.05(.05).25)
graph export "figures\A8_SP_unified_v_sum_growthandtrade_all_withrecomposed.pdf", as(pdf) replace


* --- 5 TRADE CHANNEL DECOMPOSITION

* need to rescale
replace direct_feb2019_NH = direct_feb2019_NH *10 / rhotilde
replace lambda_NH = lambda_NH *10 / rhotilde
replace io_NH = 10* io_NH  / rhotilde
replace mr_feb2019_NH = 10* mr_feb2019_NH / rhotilde
replace p2_NH = 10 * p2_NH / rhotilde
replace noapprox_NH = 10 * noapprox_NH / rhotilde

g demand_NH = lambda_NH + p2_NH
g sum_approx_NH = mr_feb2019_NH + demand_NH + direct_feb2019_NH + io_NH 

* homothetic:
replace noapprox_H  = noapprox_H *10 / rhotilde
replace direct_feb2019_H  = direct_feb2019_H  *10 / rhotilde
replace lambda_H  = lambda_H  *10 / rhotilde
replace io_H  = 10* io_H   / rhotilde
replace mr_feb2019_H  = 10* mr_feb2019_H  / rhotilde
replace p2_H  = 10 * p2_H / rhotilde

g demand_H  = lambda_H  + p2_H
g sum_approx_H  = mr_feb2019_H  + demand_H  + direct_feb2019_H  + io_H  

 
* compute NH to H differences
g mr_feb2019_NH_H_diff = mr_feb2019_NH - mr_feb2019_H
g demand_NH_H_diff = demand_NH - demand_H
g direct_feb2019_NH_H_diff = direct_feb2019_NH - direct_feb2019_H
g io_NH_H_diff = io_NH - io_H
g sum_approx_NH_H_diff = sum_approx_NH - sum_approx_H


g lambda_NH_H_diff = lambda_NH - lambda_H
g p2_NH_H_diff = p2_NH - p2_H


* TABLE 2: The effect of trade on the skill premium (in %): decomposition of the difference between
* non-homothetic and homothetic preferences. Average over countries which experienced a reduction in
* trade costs.

* Note: copy to Excel and normalize such that the decomposition total matches the GE total (first line)

sum tradeonly_1995_2009_NH_H_diff if pci < 785  & tradecost_NH<1 &  region !="ZWE" & region !="JPN"
*sum tot_decomp if pci < 785  & tradecost_NH<1 &  region !="ZWE" & region !="JPN"
sum direct_feb2019_NH_H_diff if pci < 785  & tradecost_NH<1 &  region !="ZWE" & region !="JPN"
sum demand_NH_H_diff if pci < 785  & tradecost_NH<1 &  region !="ZWE" & region !="JPN"
sum io_NH_H_diff if pci < 785  & tradecost_NH<1 &  region !="ZWE" & region !="JPN"
sum mr_feb2019_NH_H_diff if pci < 785  & tradecost_NH<1 &  region !="ZWE" & region !="JPN"


sum tradeonly_1995_2009_NH_H_diff if pci > 785  &  pci < 8500  & tradecost_NH<1 &  region !="ZWE" & region !="JPN"
*sum tot_decomp if pci > 785  &  pci < 8500  & tradecost_NH<1 &  region !="ZWE" & region !="JPN"
sum direct_feb2019_NH_H_diff if pci > 785  &  pci < 8500  & tradecost_NH<1 &  region !="ZWE" & region !="JPN"
sum demand_NH_H_diff if pci > 785  &  pci < 8500   & tradecost_NH<1 &  region !="ZWE" & region !="JPN"
sum io_NH_H_diff if pci > 785  &  pci < 8500   & tradecost_NH<1 &  region !="ZWE" & region !="JPN"
sum mr_feb2019_NH_H_diff if pci > 785  &  pci < 8500  & tradecost_NH<1 &  region !="ZWE" & region !="JPN"

* high income (from WB)
sum tradeonly_1995_2009_NH_H_diff if  pci > 8500  & tradecost_NH<1 &  region !="ZWE" & region !="JPN"
sum tot_decomp if pci > 8500  & tradecost_NH<1 &  region !="ZWE" & region !="JPN"
sum direct_feb2019_NH_H_diff if pci > 8500  & tradecost_NH<1 &  region !="ZWE" & region !="JPN"
sum demand_NH_H_diff if pci > 8500  & tradecost_NH<1 &  region !="ZWE" & region !="JPN"
sum io_NH_H_diff if pci > 8500  & tradecost_NH<1 &  region !="ZWE" & region !="JPN"
sum mr_feb2019_NH_H_diff if pci > 8500  & tradecost_NH<1 &  region !="ZWE" & region !="JPN"

* -----

* Figure 6a: Trade channel. Decomposition into the `direct' and the `demand' effects of trade cost
* reductions on the skill premium.
twoway (scatter  direct_feb2019_H logpci if tradecost_NH<1 & direct_feb2019_H <0.9 & direct_feb2019_H > -0.3 , yline(0, lcolor(gs8))  mlabsize(vsmall) mcolor(navy) msize(small) msymb(triangle) mlabel(region)) ///
(lfit  direct_feb2019_H logpci if tradecost_NH<1, lcolor(navy) lpattern(longdash)) ///
(scatter  direct_feb2019_NH logpci if tradecost_NH<1 & direct_feb2019_NH <0.9 & direct_feb2019_NH > -0.3 , yline(0, lcolor(black))  mcolor(maroon) mlabcolor(maroon) mlabsize(vsmall)  yline(0, lcolor(gs8))  msize(small) mlabel(region)) ///
(lfit  direct_feb2019_NH logpci if tradecost_NH<1,  lcolor(maroon)), ///
ytitle("Skill premium increase") xtitle("Log per capita expenditures") title("") ///
legend(label(1 "Homothetic preferences")  label(2 "")  label(3 "Non-homothetic pref.") label(4 "") col(4))
graph export "figures\6a_trade_decomp_NH_H_direct_TCreduconly.pdf", as(pdf) replace


* Figure 6b: Trade channel. Decomposition into the `direct' and the `demand' effects of trade cost
* reductions on the skill premium.
twoway (scatter  demand_H logpci if tradecost_NH<1  , yline(0, lcolor(gs8))  mlabsize(vsmall) mcolor(navy) msize(small) msymb(triangle) mlabel(region)) ///
(lfit  demand_H logpci if tradecost_NH<1, lcolor(navy) lpattern(longdash)) ///
(scatter  demand_NH logpci if tradecost_NH<1 & region!="VNM" , yline(0, lcolor(black))  mcolor(maroon) mlabcolor(maroon) mlabsize(vsmall)  yline(0, lcolor(gs8))  msize(small) mlabel(region)) ///
(lfit  demand_NH logpci if tradecost_NH<1,  lcolor(maroon)), ///
ytitle("Skill premium increase") xtitle("Log per capita expenditures") title("") ///
legend(label(1 "Homothetic preferences")  label(2 "")  label(3 "Non-homothetic pref.") label(4 "") col(4))
graph export "figures\6b_trade_decomp_NH_H_demand_TCreduconly.pdf", as(pdf) replace
	
	
* --- 6 ROBUSTNESS CHECKS


* EFFECT OF RHO

* run CF_skill.gms with rho = 1.7 and import results 
* import rhotilde and skillpremium change

replace skillprem_rho17 = skillprem_rho17 -1 

gen adjust_rho14 = unified_1995_2009 * rhotilde
gen adjust_rho17 = skillprem_rho17 * rhotilde_17

label var adjust_rho14 "elasticity of substitution rho=1.4"
label var adjust_rho17 "elasticity of substitution rho=1.7"

label var noapprox_rho14 "elasticity of substitution rho=1.4"
label var noapprox_rho17  "elasticity of substitution rho=1.7"

* graph comparing rho =1.4 to rho =1.7 (not in paper)
twoway 	(line adjust_rho14  adjust_rho14  , lcolor(navy)) ///
(scatter adjust_rho17  adjust_rho14 , msize(small) mcolor(navy)), ///
graphregion(lcolor(white) fcolor(white))  legend(off) xlabel(, labsize(small)) ylabel(, labsize(small))  ///
ytitle("Elasticity of substitution rho=1.7", size(small)) xtitle("Elasticity of substitution rho=1.4", size(small))
*graph export "figures\comparison_rho_revision.pdf", as(pdf) replace

* in paper, used R2 only:
reg adjust_rho17  adjust_rho14


* THETA 4 and HETEROBETA

rename cf_prod_yes_trade_yes_nh_t4 unified_1995_2009_t4
rename cf_prod_yes_trade_yes_h_t4 unified_1995_2009_H_t4
	
g unified_1995_2009_NH_H_diff_t4  = unified_1995_2009_t4 - unified_1995_2009_H_t4	


rename  unif_prod_yes_trade_yes_nhcsbeta unified_1995_2009_csbeta
rename unif_prod_yes_trade_yes_h_csbeta  unified_1995_2009_H_csbeta	

g unified_NH_H_diff_csbeta = 	unified_1995_2009_csbeta - unified_1995_2009_H_csbeta
	
* Figure A.4: Alternative specifications for the unified counterfactual
twoway (scatter unified_1995_2009_NH_H_diff logpci, yline(0, lcolor(gs8)) msize(small) mcolor(navy)) ///
(lfit unified_1995_2009_NH_H_diff logpci, lcolor(navy) ) ///
(scatter unified_1995_2009_NH_H_diff_t4 logpci, yline(0, lcolor(gs8)) msize(small) mcolor(maroon)  msymb(triangle) mlabcolor(maroon) mlabsize(vsmall)) ///
(lfit unified_1995_2009_NH_H_diff_t4 logpci, lpattern(longdash) lcolor(maroon)) ///
(scatter unified_NH_H_diff_csbeta logpci, yline(0, lcolor(gs8)) msize(small) mcolor(green) msymb(sh) mlabcolor(maroon) mlabsize(vsmall)) ///
(lfit unified_NH_H_diff_csbeta logpci, lpattern(shortdash) lcolor(green)), ///
ytitle("Difference in skill premium increase", size(small)) xtitle("Log per capita expenditures", size(small)) title("") ///
legend(label(1 "Benchmark specification with heterogenous theta")  label(3 "Theta = 4 in all sectors") label(5 "Alternative skill intensity")  label(2 "") label(4 "")  label(6 "") col(2) ring(1) size(small) ) ///
graphregion(lcolor(white) fcolor(white)) xlabel(, labsize(small)) ylabel(, labsize(small)) 
graph export "figures\A4_SP_unified_NH_H_Diff_t4_heterobeta.pdf", as(pdf) replace	

	
* -- 7 CLM PREFERENCES

* load results from Merged.gdx
*drop unified_1995_2009
rename  cf_prod_yes_trade_yes_nh_clm unified_1995_2009clm
rename cf_prod_yes_trade_yes_h_clm  unified_1995_2009_Hclm

twoway (scatter unified_1995_2009_Hclm logpci if region!="ZWE" & region!="VNM", yline(0, lcolor(gs8)) mlabsize(vsmall) mcolor(navy) msize(small) msymb(triangle) mlabel(region)) ///
(scatter unified_1995_2009clm logpci if region!="ZWE", yline(0, lcolor(gs8)) msize(small) mcolor(maroon) mlabcolor(maroon) mlabsize(vsmall)  mlabel(region)) ///
(lfit unified_1995_2009_Hclm logpci, lcolor(navy) lpattern(longdash)) ///
(lfit unified_1995_2009clm logpci,  lcolor(maroon)), ///
ytitle("Skill premium increase", size(small)) xtitle("Log per capita expenditures", size(small)) title("") ///
legend(label(1 "Homothetic preferences")  label(2 "Non-homothetic preferences") label(3 "Linear Fit") label(4 "Linear Fit") size(small)) ///
graphregion(lcolor(white) fcolor(white)) xlabel(, labsize(small)) ylabel(, labsize(small))  
graph export "figures\A5_SP_unified_growthandtrade_95_09_NH_Hclm.pdf", as(pdf) replace


* --------- 8 - some statistics regarding the magnitude of simulated shocks for the paper

sum realincomegeoavgchg, detail
corr  realincomegeoavgchg logpci

corr  realincomegeoavgchg prodshock_NH
sum prodshock_NH, detail

sum exportgdpchg, detail
count if exportgdpchg <  0
corr  exportgdpchg   logpci

corr tradecost_NH exportgdpchg
corr prodshock_NH tradecost_NH 


corr tradecost_NH exportgdpchg
sum tradecost_NH 
count if tradecost_NH >  0


* Table A.3: 1995-2010 percentage changes in productivity, trade cost shocks and implied changes in
* the simulated skill premium. CTRYTABLE

order region pci realincomegeoavgchg  exportgdpchg  prodshock_NH tradecost_NH unified_1995_2009 growthonly_1995_2009 tradeonly_1995_2009
* export to ecel



 * --- 9 COMPARISON to WIOD skill premium estimates

* merge in skill premium estimates from WIOD
* these are from WIOD/skill premium analysis 2019.do
merge m:m region using "WIOD/skill_premium_wiod.dta"	
drop _merge
* note: all WIOD countries are also in GTAP5
	
* merge in years of schooling from Barro and Lee (used for correlation table)
merge m:m region using "WIOD/Barro lee 25_yr schooling.dta"
drop _merge

g skillprem_0995_ratio_M1 = skillprem_0995_ratio_M -1


* Figure 7: Comparison of observed 1995 to 2010 changes in the skill premium with simulated estimates.
twoway (scatter   unified_1995_2009_H skillprem_0995_ratio_M1 if skillprem_0995_ratio_M !=., yline(0, lcolor(gs8))  mlabsize(vsmall) mcolor(navy) msize(small) msymb(triangle) mlabel(region)) ///
(scatter   unified_1995_2009 skillprem_0995_ratio_M1 if skillprem_0995_ratio_M !=., yline(0, lcolor(black))  mcolor(maroon) mlabcolor(maroon) mlabsize(vsmall)  yline(0, lcolor(gs8))  msize(small) mlabel(region)) ///
(lfit   unified_1995_2009_H skillprem_0995_ratio_M1 if skillprem_0995_ratio_M !=., lcolor(navy) lpattern(longdash)) ///
(lfit   unified_1995_2009 skillprem_0995_ratio_M1 if skillprem_0995_ratio_M !=.,  lcolor(maroon)), ///
xtitle("Observed change in the skill premium  (WIOD)", size(small)) ytitle("Simulated change in the skill premium ", size(small)) title("") ///
legend(label(1 "Homothetic preferences")  label(2 "Non-homothetic preferences") label(3 "Linear Fit") label(4 "Linear Fit") size(small)) ///
graphregion(lcolor(white) fcolor(white)) xlabel(, labsize(small)) ylabel(, labsize(small))  
graph export "figures\7_SP_comparisonstoWiod_NH_andH.pdf", as(pdf) replace

* regression coeffs for caption
reg unified_1995_2009_H skillprem_0995_ratio_M, robust beta
reg unified_1995_2009 skillprem_0995_ratio_M, robust beta
*reg skillprem_0995_ratio_M   unified_1995_2009_NH_H_diff yrschool_1095_ratio, robust beta
reg skillprem_0995_ratio_M   unified_1995_2009_NH_H_diff , robust beta


* ------------------

*Table A.5: Correlations between observed changes in the skill premium and simulated estimate


reg skillprem_0995_ratio_M unified_1995_2009 yrschool_1095_ratio  , beta
estimates store NH_yrsch

reg skillprem_0995_ratio_M unified_1995_2009_H yrschool_1095_ratio  , beta
estimates store H_yrsch

reg skillprem_0995_ratio_M unified_1995_2009_NH_H_diff yrschool_1095_ratio  , beta
estimates store diff_yrsch

reg skillprem_0995_ratio_M growthonly_1995_2009_NH_H_diff yrschool_1095_ratio  , beta
estimates store growth_diff_yrsch

reg skillprem_0995_ratio_M tradeonly_1995_2009_NH_H_diff yrschool_1095_ratio  , beta
estimates store trade_diff_yrsch


* -----------

* USE THIS FOR  TABLE: copy to excel
esttab NH_yrsch H_yrsch diff_yrsch growth_diff_yrsch trade_diff_yrsch, beta se  star 

* then use this one with the coefficients to standardize the SE as well -- and use this for the p-value
esttab NH_yrsch H_yrsch diff_yrsch growth_diff_yrsch trade_diff_yrsch,  p  star 


















