$title	loaddata_gtap5.GMS	Read a GTAP 5 dataset


* ------------------------------------------------------
* Per Capita Income and the Demand for Skills
* Journal of International Economics

* Justin Caron, Thibault Fally and James Markusen

* December 2019
* ------------------------------------------------------

* This file is adapted from Thomas Rutherford's GTAP-in-GAMS package
* MPSGE.org



$if not set nd $set nd 0

scalar nd	Number of decimals /%nd%/;
abort$(nd<>round(nd)) "Number of decimals must be an integer";

$if not set ds $set ds gsd
$if not set yr $set yr 07
$if not set datadir $set datadir "data\"
$setglobal datadir %datadir%

set	g(*)	Goods plus C and G;

$if exist %ds%.gdx $gdxin '%ds%.gdx'
$if not exist %ds%.gdx $gdxin '%datadir%%ds%.gdx'
$load g

set	i(g)	Goods
	f(*)	Factors;
$load f i 
$if declared hs6 $load hs6
$if not defined r	set r(*)	Regions;
$if not defined r	$load r


set	rnum(r)	Numeraire region,
	sf(f)	Sluggish primary factors (sector-specific),
	mf(f)	Mobile primary factors;

alias (r,s), (i,j);

display r;
parameters
	vfm(f,g,r)	Endowments - Firms' purchases at market prices,
	vdfm(i,g,r)	Intermediates - firms' domestic purchases at market prices,
	vifm(i,g,r)	Intermediates - firms' imports at market prices,
	vxmd(i,r,s)	Trade - bilateral exports at market prices,
	vst(i,r)	Trade - exports for international transportation
$if declared hs6	viws_hs6(i,hs6,r,s)	Bilateral trade at world prices (HS6 goods)
	vtwr(i,j,r,s)	Trade - Margins for international transportation at world prices;

$load vfm vdfm vifm vxmd vst vtwr 
$if declared hs6 $load viws_hs6 

if (nd>0,
	vfm(f,g,r) = vfm(f,g,r)$round(vfm(f,g,r),nd);
	vdfm(i,g,r) = vdfm(i,g,r)$round(vdfm(i,g,r),nd);
	vifm(i,g,r) = vifm(i,g,r)$round(vifm(i,g,r),nd);
	vxmd(i,r,s) = vxmd(i,r,s)$round(vxmd(i,r,s),nd);
	vst(i,r) = vst(i,r)$round(vst(i,r),nd);
	vtwr(i,j,r,s) = vtwr(i,j,r,s)$round(vtwr(i,j,r,s),nd);
$if declared hs6	viws_hs6(i,hs6,r,s) = viws_hs6(i,hs6,r,s)$round(viws_hs6(i,hs6,r,s),nd);
);


set tartype		tariff type (ad-valorem or specific) /adv, spe/;

parameter
	rto(g,r)	Output (or income) subsidy rates
	rtf(f,g,r)	Primary factor and commodity rates taxes 
	rtfd(i,g,r)	Firms domestic tax rates
	rtfi(i,g,r)	Firms' import tax rates
	rtxs(i,r,s)	Export subsidy rates
$if declared hs6	rtms_hs6(hs6,r,s)	Bilateral tariff rates
	rtms(i,r,s)	Import taxes rates;
*	rtmssa(tartype,i,r,s)	Import taxes rates;


$load rto rtf rtfd rtfi rtxs rtms 
* rtmssa
$if declared hs6 $load rtms_hs6

if (nd>0,
	rto(g,r) = rto(g,r)$round(rto(g,r),nd);
	rtf(f,g,r) = rtf(f,g,r)$round(rtf(f,g,r),nd);
	rtfd(i,g,r) = rtfd(i,g,r)$round(rtfd(i,g,r),nd);
	rtfi(i,g,r) = rtfi(i,g,r)$round(rtfi(i,g,r),nd);
	rtxs(i,r,s) = rtxs(i,r,s)$round(rtxs(i,r,s),nd);
	rtms(i,r,s) = rtms(i,r,s)$round(rtms(i,r,s),nd);
*	rtmssa(tartype,i,r,s) = rtmssa(tartype,i,r,s)$round(rtmssa(tartype,i,r,s),nd);

$if declared hs6  rtms_hs6(hs6,r,s) = rtms_hs6(hs6,r,s)$round(rtms_hs6(hs6,r,s),nd);
);
parameter
	esubd(i)	Elasticity of substitution (M versus D),
	esubva(g)	Elasticity of substitution between factors
	esubm(i)	Intra-import elasticity of substitution,
	etrae(f)	Elasticity of transformation,
	eta(i,r)	Income elasticity of demand,
	epsilon(i,r)	Own-price elasticity of demand;

$load esubd esubva esubm etrae 
*eta epsilon

parameter
	evdd(i,g,r)		Volume of domestic energy demand (mtoe),
	evdi(i,g,r)		Volume of imported energy demand (mtoe),
	evt(i,r,r)		Volume of energy trade (mtoe)
	eco2d(i,g,r)		Emissions of CO2 from domestic source (Gg),
	eco2i(i,g,r)		Emissions of CO2 from imported source (Gg)
	eco2(i,g,r);

$loaddc 
*evdd evdi
$loaddc  evt eco2 

*eco2d eco2i
if (nd>0,
*	evdd(i,g,r) = evdd(i,g,r)$round(evdd(i,g,r),   nd);
*	evdi(i,g,r) = evdi(i,g,r)$round(evdi(i,g,r),   nd);
*	eco2d(i,g,r) = eco2d(i,g,r)$round(eco2d(i,g,r),   nd);
*	eco2i(i,g,r) = eco2i(i,g,r)$round(eco2i(i,g,r),   nd);

	evt(i,r,s) = evt(i,r,s)$round(evt(i,r,s),   nd);
);

*eco2(i,g,r) = eco2i(i,g,r) + eco2d(i,g,r);


*	Declare some intermediate arrays which are required to 
*	evaluate tax rates:

parameter	vdm(g,r)	Aggregate demand for domestic output,
		vom(g,r)	Total supply at market prices;

vdm(i,r) = sum(g, vdfm(i,g,r));
vom(i,r) = vdm(i,r) + sum(s, vxmd(i,r,s)) + vst(i,r);

parameter
	rtf0(f,g,r)	Primary factor and commodity rates taxes 
	rtfd0(i,g,r)	Firms domestic tax rates
	rtfi0(i,g,r)	Firms' import tax rates
	rtxs0(i,r,s)	Export subsidy rates
	rtms0(i,r,s)	Import taxes rates;

rtf0(f,g,r) = rtf(f,g,r);
rtfd0(i,g,r) = rtfd(i,g,r);
rtfi0(i,g,r) = rtfi(i,g,r);
rtxs0(i,r,s) = rtxs(i,r,s);
rtms0(i,r,s) = rtms(i,r,s);

parameter	pvxmd(i,s,r)	Import price (power of benchmark tariff)
		pvtwr(i,s,r)	Import price for transport services;

pvxmd(i,s,r) = (1+rtms0(i,s,r)) * (1-rtxs0(i,s,r));
pvtwr(i,s,r) = 1+rtms0(i,s,r);

parameter	
	vtw(j)		Aggregate international transportation services,
	vpm(r)		Aggregate private demand,
	vgm(r)		Aggregate public demand,
	vim(i,r)	Aggregate imports,
	evom(f,r)	Aggregate factor endowment at market prices,
	vb(*)		Current account balance;

vtw(j) = sum(r, vst(j,r));
vom("c",r) = sum(i, vdfm(i,"c",r)*(1+rtfd0(i,"c",r)) + vifm(i,"c",r)*(1+rtfi0(i,"c",r)));
vom("g",r) = sum(i, vdfm(i,"g",r)*(1+rtfd0(i,"g",r)) + vifm(i,"g",r)*(1+rtfi0(i,"g",r)));
vom("i",r) = sum(i, vdfm(i,"i",r)*(1+rtfd0(i,"i",r)) + vifm(i,"i",r)*(1+rtfi0(i,"i",r)));

vdm("c",r) = vom("c",r);
vdm("g",r) = vom("g",r);
vim(i,r) =  sum(g, vifm(i,g,r));
evom(f,r) = sum(g, vfm(f,g,r));
vb(r) = vom("c",r) + vom("g",r) + vom("i",r) 
	- sum(f, evom(f,r))
	- sum(j,  vom(j,r)*rto(j,r))
	- sum(g,  sum(i, vdfm(i,g,r)*rtfd(i,g,r) + vifm(i,g,r)*rtfi(i,g,r)))
	- sum(g,  sum(f, vfm(f,g,r)*rtf(f,g,r)))
	- sum((i,s), rtms(i,s,r) *  (vxmd(i,s,r) * (1-rtxs(i,s,r)) + sum(j,vtwr(j,i,s,r))))
	+ sum((i,s), rtxs(i,r,s) * vxmd(i,r,s));

vb("chksum") = sum(r, vb(r));
display vb;

*	Determine which factors are sector-specific 

mf(f) = yes$(1/etrae(f)=0);
sf(f) = yes$(1/etrae(f)>0);
display mf,sf;

parameter       mprofit Zero profit for m,
                yprofit Zero profit for y;

mprofit(i,r) = vim(i,r) - sum(s, pvxmd(i,s,r)*vxmd(i,s,r)+sum(j, vtwr(j,i,s,r))*pvtwr(i,s,r));
mprofit(i,r) = round(mprofit(i,r),5);
display mprofit;

yprofit(g,r) = vom(g,r)*(1-rto(g,r))-sum(i, vdfm(i,g,r)*(1+rtfd0(i,g,r))
        + vifm(i,g,r)*(1+rtfi0(i,g,r))) - sum(f, vfm(f,g,r)*(1+rtf0(f,g,r)));
yprofit(i,r) = round(yprofit(i,r),6)
display yprofit;

*	Define a numeraire region for denominating international
*	transfers:

rnum(r) = yes$(vom("c",r)=smax(s,vom("c",s)));
display rnum;


* -------------------------------------------------------------------
* extra parameters for PCIintrade project
* -------------------------------------------------------------------

* -- SOME DATA FILTERING :
* drop negligible trade flows
vxmd(i,r,s) = round( vxmd(i,r,s), 8);
rtms(i,r,s)$(vxmd(i,r,s) = 0) = 0;
*vtwr(i,r,s)$(vxmd(i,r,s) = 0) = 0;
*(i,r,s)$(vxmd(i,r,s) = 0) = 0;




* -- data to extract from gtap :

parameter
*       caplab          capital labor ratio
                fd              final demand
                domfd		domestic final demand
		impfd           imported final demand
		absorbtion	absorbtion
*                expend          final demand = expenditure = C
                expshare(*,*)   sectoral shares of total expenditure (sigma)
                labor(r)        value-added generated by labor
                income(r)       income
                gdp(r)          gdp
                expenditure(r)  expenditure
                pcGDP(*)        per capita gdp (m)
                pcEXP           per capita expenditure
                btrade          bilateral trade flows (CIF)
                btariff         bilateral tariff
                btcost          bilateral transport cost
		pop(*)          population
		Endow(f,r)      endowment in factor f

;

alias(i,ii);

gdp(r)=sum(g,vom(g,r))-sum((i,g),vdfm(i,g,r)+vifm(i,g,r));



* GTAP7 population data
$ONTEXT
* -------- IMPORT POPULATION DATA

*       Read the CIESIN population data:

set     sresscn /a1,b1,a2,b2/;

set     tyr     Points in time for CIESIN database
        /1990, 1995, 2000, 2005, 2010, 2015, 2020, 2025, 2030, 2035, 2040, 2045, 2050,
         2055, 2060, 2065, 2070, 2075, 2080, 2085, 2090, 2095, 2100/;

parameter popdata(sresscn,*,tyr) "Population database from http://ciesin.columbia.edu/datasets/downscaled/";
$gdxin '%datadir%ciesin_gtap7.gdx'
$loaddc popdata

* some countries lack population data, which ones?
set nopopdata(r);
nopopdata(r)=yes;
nopopdata(r)$popdata("a1",r,"2005")=no;
display nopopdata;
* missing are : twn (taiwan) and XNA(rest of north america = bermuda, greenland)
* I thus drop XNA and manually insert taiwan pop from wikipedia: 22,805,547 in 2006
popdata("a1","TWN","2005")=22805547;
popdata("a1","XNA","2005")=200000;

pop(r) = popdata("a1",r,"2005");

$OFFTEXT

* FOR GTAP 5, no population vector
* 1997 populations downloaded from the World Bank website

parameter pop(*) /
ABW	85451
AFG	18381605
AGO	15088981
ALB	3148281
AND	64327
ARB	266575075
ARE	2700010
ARG	35833969
ARM	3133086
ASM	54941
ATG	77739
AUS	18517000
AUT	7968041
AZE	7838250
BDI	6112097
BEL	10181245
BEN	6281639
BFA	10665546
BGD	123854640
BGR	8312068
BHR	594930
BHS	286970
BIH	3752431
BLR	10117000
BLZ	221606
BMU	60497
BOL	7870855
BRA	167545164
BRB	266945
BRN	312038
BTN	528754
BWA	1637635
CAF	3517309
CAN	29987200
CEB	109459093
CHE	7088906
CHI	145715
CHL	14694835
CHN	1230075000
CIV	15445986
CMR	14165423
COD	43830146
COG	2962470
COL	38645411
COM	501953
CPV	408175
CRI	3682725
CSS	6392040
CUB	11013983
CUW	146956
CYM	35597
CYP	891192
CZE	10304131
DEU	82034771
DJI	660953
DMA	70753
DNK	5284991
DOM	8163472
DZA	29886839
EAP	1759201938
EAR	2341634408
EAS	1986799861
ECA	392200932
ECS	859112733
ECU	11924993
EGY	66151117
EMU	318761764
ERI	3161350
ESP	40057389
EST	1399535
ETH	60976450
EUU	485892094
FCS	314393550
FIN	5139835
FJI	792860
FRA	59964851
FRO	46251
FSM	108502
GAB	1142324
GBR	58316954
GEO	4531600
GHA	17608812
GIB	30594
GIN	8337988
GMB	1128169
GNB	1179727
GNQ	544636
GRC	10661259
GRD	101122
GRL	56000
GTM	10887634
GUM	150303
GUY	760510
HIC	1093603568
HKG	6489300
HND	6028882
HPC	437269757
HRV	4572000
HTI	8111951
HUN	10290486
IBD	3840453296
IBT	4851072372
IDA	1010619076
IDB	336924643
IDN	202826465
IDX	673694433
IMN	70869
IND	997405318
IRL	3674171
IRN	62710557
IRQ	21509291
ISL	271128
ISR	5836000
ITA	56890372
JAM	2586827
JOR	4832267
JPN	126057000
KAZ	15333703
KEN	28954114
KGZ	4696400
KHM	11295880
KIR	80184
KNA	43846
KOR	45953580
KWT	1715314
LAC	439044994
LAO	5056519
LBN	3092670
LBR	2358469
LBY	5117269
LCA	151086
LCN	501837820
LDC	616437048
LIC	429730581
LIE	31838
LKA	18476505
LMC	2161549857
LMY	4785830332
LSO	1810453
LTE	1996172104
LTU	3575137
LUX	419450
LVA	2432851
MAC	401564
MAF	31304
MAR	27825901
MCO	31251
MDA	3654208
MDG	14347854
MDV	264275
MEA	298982946
MEX	97281739
MHL	51692
MIC	4356099751
MKD	1999599
MLI	10114094
MLT	382791
MMR	44371525
MNA	265463944
MNE	609520
MNG	2335695
MNP	62528
MOZ	16701351
MRT	2471598
MUS	1148284
MWI	10381862
MYS	21565325
NAC	302704697
NAM	1758994
NCL	201418
NER	10180061
NGA	113522705
NIC	4786640
NLD	15610650
NOR	4405157
NPL	22389803
NRU	10057
NZL	3781300
OED	1136083409
OMN	2249773
OSS	19820997
PAK	129086987
PAN	2853941
PER	24827406
PHL	73064764
PLW	18123
PNG	5154910
POL	38649660
PRE	510777895
PRI	3759430
PRK	22335638
PRT	10108977
PRY	4980344
PSE	2706518
PSS	1894564
PST	1005863664
PYF	223731
QAT	534608
*ROU	22553978
ROM	22553978
RUS	147915307
RWA	6522382
SAS	1310387887
SAU	19505576
SDN	25410451
SEN	9196528
SGP	3796038
SLB	379947
SLE	4305455
SLV	5727755
SMR	26508
SOM	8137475
SRB	7596501
SSA	619530637
SSD	5814006
SSF	619607956
SST	28107601
STP	131107
SUR	455954
SVK	5383291
SVN	1985956
SWE	8846062
SWZ	1003995
SYC	77319
SYR	15177456
TCA	16528
TCD	7493251
TEA	1736829482
TEC	435422592
TGO	4534551
THA	60863506
TJK	5934282
TKM	4355114
TLA	486067029
TLS	871994
TMN	262757426
TON	96725
TSA	1310387887
TSS	619607956
TTO	1260678
TUN	9384152
TUR	60372499
TUV	9277
TZA	31635251
UGA	21865931
UKR	50594105
UMC	2194549894
URY	3271010
USA	272657000
UZB	23667000
VCT	108004
VEN	23110178
VGB	19270
VIR	108357
VNM	77453335
VUT	174999
WLD	5879433900
WSM	172198
XKX	2086000
YEM	16408954
ZAF	43657024
ZMB	9666578
ZWE	11709997
/;

set nopopdata(r);
nopopdata(r)=yes;
nopopdata(r)$pop(r)=no;
display nopopdata;

pop("TWN")=20005547;


* transform to millions :
*pop(r) = pop(r) / 1000000 ;



domfd(i,r) = vdfm(i,"c",r)+vdfm(i,"g",r)+vdfm(i,"i",r);
impfd(i,r) = vifm(i,"c",r)+vifm(i,"g",r)+vifm(i,"i",r);
fd(i,r)= domfd(i,r)+impfd(i,r);
expenditure(r) = sum(i, fd(i,r));
* calculate per-capita values:
pcEXP(r)$pop(r) = 10e8*expenditure(r)/pop(r);
Endow(f,r) = sum(g,vfm(f,g,r));

btariff(i,s,r) = (1+rtms0(i,s,r)) * (1-rtxs0(i,s,r));
btrade(i,r,s) = btariff(i,r,s)*vxmd(i,r,s) + sum(j, vtwr(j,i,r,s))*pvtwr(i,r,s);
absorbtion(i,r) = sum(g, vdfm(i,g,r)+ vifm(i,g,r));


parameter taxrevenue(r); 

taxrevenue(r) =  sum(j,  vom(j,r)*rto(j,r))
	+ sum(g,  sum(i, vdfm(i,g,r)*rtfd(i,g,r) + vifm(i,g,r)*rtfi(i,g,r)))
	+ sum(g,  sum(f, vfm(f,g,r)*rtf(f,g,r)))
	+ sum((i,s), rtms(i,s,r) *  (vxmd(i,s,r) * (1-rtxs(i,s,r)) + sum(j,vtwr(j,i,s,r))))
	- sum((i,s), rtxs(i,r,s) * vxmd(i,r,s));


* -- LOAD DISTANCE DATA
* updated with set of GTAP 8 regions

set dist /   ldist,    contig,comlang_off, colony,    homebias,  rta,  bothsea,  comcur, common_legor /;


parameter  importdist(r,s,dist);


*$if not exist %datadir%tradecostimp.gdx $call gdxxrw i=%datadir%trade_cost_proxies.xlsx o=%datadir%tradecostimp.gdx par=importdist rng="sheet1!a1:l8837" cdim=1 rdim=2
$gdxin %datadir%tradecostimp.gdx
$load importdist

*display importdist;

*fix Romania -- use bulgaria as proxy
importdist("rom",r,dist) = importdist("BGR",r,dist); 
importdist(r,"rom",dist) = importdist(r,"BGR",dist); 

display importdist;
importdist(r,s,"homebias")$sameas(r,s) = 1; 

set nodistdata;
nodistdata(r)$(not sum(s,importdist(r,s,"ldist"))) = yes;
display nodistdata;


