

* ------------------------------------------------------
* Per Capita Income and the Demand for Skills
* Journal of International Economics

* Justin Caron, Thibault Fally and James Markusen

* December 2019
* ------------------------------------------------------

* load data from GAMS:
* copy the COEFFS parameter compiled in data_preparation_gtap5.gdx and unloaded onto: DATA_GTAP5_TC.GDX
* copy with sectors as rows and parameters as columns

rename var1 sector

* Drop intermediates
drop if sector == "coa" | sector == "omn" | sector == "i_s" | sector == "nfm" | sector == "fmp"
drop if sector == "gas"	   

* merge sector names
merge 1:m sector using "sectornames.dta"
drop _merge

save "sector_coeffs.dta", replace 


* FIGURE A7 Correlation between average export shares and skill intensity across sectors.

gen tradable = 1 if skillinttotalweighted  < 0.45 & sector != "ely" & sector != "wtp" ///
	& sector != "cns" & sector != "atp" & sector != "otp" & sector != "wtr" & sector != "gdt"
	   	   
twoway (scatter avgtradeshare skillinttotalweighted if tradable != 1, msize(small) mlabel(sector) mlabsize(small) mcolor(maroon) mlabcolor(maroon)) ///
       (scatter avgtradeshare skillinttotalweighted if tradable == 1, msize(small) mlabel(sector) mlabsize(small) msymb(triangle) mcolor(navy) mlabcolor(navy)) ///
       (lfit avgtradeshare skillinttotalweighted, lcolor(maroon) lpattern(longdash) ) ///
       (lfit avgtradeshare skillinttotalweighted if tradable == 1, lcolor(navy) lpattern(longdash) ), ///
ytitle("Average export shares", size(small)) xtitle("Skill intensity", size(small)) title("") ///
legend(label(1 "All sectors")  label(2 "Excluding services.") label(3 "Linear Fit") label(4 "Linear Fit") size(small)) ///
graphregion(lcolor(white) fcolor(white)) xlabel(, labsize(small)) ylabel(, labsize(small))  /// 
xlabel(.1(.1).5, valuelabel) ylabel(0(.1).5, valuelabel) 
graph export "figures\A7_correlation_export_skillint.pdf", as(pdf) replace


* correlations between income elasticity and trade share
reg avgtradeshare incelastmeanshares, beta
reg avgtradeshare incelastmeanshares if tradable == 1, beta

* corresponding graph, not in paper:
twoway (scatter avgtradeshare incelastmeanshares if tradable != 1, msize(small) mlabel(sector) mlabsize(small) mcolor(maroon) mlabcolor(maroon)) ///
       (scatter avgtradeshare incelastmeanshares if tradable == 1, msize(small) mlabel(sector) mlabsize(small) msymb(triangle) mcolor(navy) mlabcolor(navy)) ///
       (lfit avgtradeshare incelastmeanshares, lcolor(maroon) lpattern(longdash) ) ///
       (lfit avgtradeshare incelastmeanshares if tradable == 1, lcolor(navy) lpattern(longdash) ), ///
ytitle("Average export shares", size(small)) xtitle("incelastmeanshares", size(small)) title("") ///
legend(label(1 "All sectors")  label(2 "Excluding services.") label(3 "Linear Fit") label(4 "Linear Fit") size(small)) ///
graphregion(lcolor(white) fcolor(white)) xlabel(, labsize(small)) ylabel(, labsize(small))  /// 
xlabel(.1(.1).5, valuelabel) ylabel(0(.1).5, valuelabel) 
graph export "figures/correlation_incel_tradeint.pdf", as(pdf) replace

* FIGURE 1 - comparing direct and total skill int
twoway (scatter    skillinttotalweighted incelastmeanshares, msize(small)  mlabsize(small) mcolor(maroon) mlabcolor(maroon)) ///
       (lfit   skillinttotalweighted incelastmeanshares , lcolor(maroon) lpattern(solid) ) ///
	   (scatter   skillintdirectweighted incelastmeanshares , msize(small)  mlabsize(small) msymb(triangle) mcolor(navy) mlabcolor(navy)) ///
       (lfit  skillintdirectweighted incelastmeanshares  , lcolor(navy) lpattern(longdash) ), ///
ytitle("Skill intensity", size(small)) xtitle("Income elasticity", size(small)) title("") ///
legend(label(1 "Total skill intensity")    label(2 "")  label(3 "Direct skill intensity.")label(4 "") size(small) cols(4))  ///
 ylabel(-0.1(0.1)0.6, valuelabel)  ///
graphregion(lcolor(white) fcolor(white)) xlabel(, labsize(small)) ylabel(, labsize(small))  
graph export "figures\1_correlation_skillint_directVtotal_vincel.pdf", as(pdf) replace


* correl
corr skillinttotalweighted skillintdirectweighted incelastmeanshares

* -------------
* TABLE 1 -PREPARING DATA FOR THE 'SECTOR' TABLE 

* thetas (TAKEN FROM FINAL NH SIMULATION FILE)
merge m:m sector using "theta_tc_fortable.dta"
drop _merge

g sector_star = sector
replace sector_star = sector + "*" if tradable == .


sort skillinttotalweighted
replace shortname = "Forestry" in 13

order sector_star  shortname skillinttotalweighted incelastmeanshares theta avgtradeshare

*then, copy to excel for formatting

* -------------
* REGRESSIONS FOR TABLE A4
* NOTE: natural resource = nat res + land (summed upstream in GAMS)


reg incelastmeanshares skillinttotalweighted, robust beta

reg incelastmeanshares skillinttotalweighted capitalinttotalweighted natresinttotalweighted, robust beta

reg incelastmeanshares skillinttotalweighted if tradable == 1, robust beta

reg incelastmeanshares skillinttotalweighted capitalinttotalweighted natresinttotalweighted if tradable == 1, robust beta

* alternatives:
reg avincelast skillint avgfactratio_totweight_capital avgfactratio_totweight_natlres, robust beta
reg avincelast skillint avgfactratio_totweight_capital avgfactratio_totweight_natlres avgfactratio_totweight_land, robust beta

* -------------
* ROBUSTNESS CHECKS

** COMPARISON WITH CLM
* copy CLM income elasticity parameters from the COEFFS parameter in estimates_gtap5_CLM.gdx

merge m:m sector using "Income_elasticity_CLM.dta"
drop _merge

* FIGURE A3 - Estimated income elasticities based Comin et al. (2016) preferences compared to benchmark CRIE preferences.
twoway (scatter clm_incel incelastmeanshares, mlabel(sector) msize(small)), ///
ytitle("Income elasticity - Comin et al. preferences", size(small)) xtitle("Income elasticity - CRIE  Benchmark", size(small)) ylabel(, labsize(small)) ///
graphregion(lcolor(white) fcolor(white))  xlabel(, labsize(small)) 
graph export "figures\A3_incelast_CLM.pdf", as(pdf) replace

corr clm_incel incelastmeanshares skillinttotalweighted
* 0.88


*** INSTRUMENTED PHI  (actually not IV but replacing the PHI.)

* note: run demand_gtap5_IV.gms and copy  from the COEFFS parameter in estimates_gtap5_IV.gdx

merge m:m sector using "Income_elasticity_IV"
drop _merge

* Figure A.2: Income elasticities estimated with and without instrumenting PHI
twoway (scatter incelast_iv incelastmeanshares, mlabel(sector) msize(small)), ///
ytitle("Income elasticity - instrumented Phi", size(small)) xtitle("Income elasticity - no IV", size(small)) ylabel(, labsize(small)) ///
graphregion(lcolor(white) fcolor(white))  xlabel(, labsize(small)) 
graph export "figures\A2_incelast_IV.pdf", as(pdf) replace

corr incelast_iv incelastmeanshares
* 0.9232

** CRIE: comparison across alternative specifications

merge m:m sector using "Income_elasticity_alternative_specifications.dta"
drop _merge

* Figure A.1: Income elasticities across alternative specications in the estimation of CRIE preferences.
graph dot (mean) incelastmeanshares (mean) nobc theta4 notc reducedform  if incelastmeanshares!=. ///
, over(sector,  sort(incelastmeanshares) label(labsize(tiny))) nofill ///
ytitle(Estimated Income elasticities , size(small))  ylabel(, labsize(small))  ///
 legend(order(1 "Benchmark" 2 "No budget constraint" 3 "Theta=4" 4 "No Phi" 5 "Reduced-form") cols(1) ring(0) position(2))  ///
marker(1, msymbol(smcircle) mcolor(navy))  marker(2, msymbol(square) mcolor(maroon) msize(small))  marker(3, msymbol(circle_hollow) msize(small))  ///
marker(4, msymbol(triangle) msize(small) mcolor(gray)) marker(5, msize(small)) marker(6, msymbol(triangle_hollow) mcolor(black) msize(small)) ndots(1) ///
graphregion(lcolor(white) fcolor(white))
graph export "figures\A1_incelast_robust.pdf", as(pdf) replace

corr incelastmeanshares notc

corr incelastmeanshares theta4

corr nobc theta4 notc incelast_iv reducedform incelastmeanshares if incelastmeanshares!=.
