:###################################

: Per Capita Income and the Demand for Skills

: Journal of International Economics

: Justin Caron, Thibault Fally and James Markusen

: December 2019

:###################################

: BATCH FILE DESCRIBING THE ESTIMATION AND SIMULATION WORKFLOW

: 1 - gravity and demand system estimation 

: 1.1 - estimate gravity equations (with asymmetric trade costs)

gams gravity_with_atc.gms

: 1.2 - estimate CRIE demand system with different specifications for theta
: theta4 = theta fixed at 4 in all sectors
: tc = theta is estimated
: note: the file estimates both homothetic and non-homothetic preferences

gams demand_gtap5.gms --spec=theta4 --objective=logweighted  
gams demand_gtap5.gms --spec=tc --objective=logweighted  

:goto end

: 1.3 - robustness checks (different demand system specifications)

: PHI = 0 (no trade costs)
gams demand_gtap5.gms --spec=notc --objective=logweighted  

: no budget constraint
gams demand_gtap5.gms --spec=nobc --objective=logweighted  

: reduced form
gams demand_gtap5.gms --spec=reducedform --objective=logweighted  

: using IV'ed PHIs
gams demand_gtap5_iv.gms --spec=tc --objective=logweighted  

: using non-homothetic CES preferences as in Comin et al. (CLM) 2016: 
gams demand_clm_t4_gtap5.gms


:goto end


: 2 - prepare data for counterfactual simulations

: this file produces DATA_gtap5_tc.gdx and DATA_gtap5_theta4.gdx which are 
: then used to calibrate the model for counterfactual simulation
: note: not done for CLM preferences  (using CRIE fitted values)

gams datapreparation_gtap5.gms --demandest=theta4 --beta=avg
gams datapreparation_gtap5.gms --demandest=tc --beta=avg

: with country-specific factor and IO shares
gams datapreparation_gtap5.gms --demandest=tc --beta=cs

:goto end

: 3 - run counterfactual simulations

: CF_Skill.gms describes the benchmark model with CES production

: 3.1 - first, simulate the `unified' counterfactual in which both GDP and export growth is targetted
gams CF_Skill.gms  --spec=NH  --tradetarg=yes --prodtarg=yes --demandest=tc
gams CF_Skill.gms  --spec=H  --tradetarg=yes --prodtarg=yes --demandest=tc

:goto end

: this file unloads the implied changes in TFP and trade costs to CF_Skill_prod_yes_trade_yes_NH.gdx
: these are used below for the decomposition exercise

:goto end

: 3.2 - then, simulate the `trade only' counterfactual
gams CF_Skill.gms  --spec=NH  --tradetarg=load --prodtarg=no --demandest=tc  
gams CF_Skill.gms  --spec=H  --tradetarg=load --prodtarg=no --demandest=tc 

: 3.3 - then, simulate the `growth only' counterfactual
gams CF_Skill.gms  --spec=NH  --tradetarg=no --prodtarg=load --demandest=tc
gams CF_Skill.gms  --spec=H  --tradetarg=no --prodtarg=load --demandest=tc

merge results
cd results/SPestimates_tomerge_tc
gdxmerge *.gdx
cd../..

:goto end

: 3.4 - robustness checks

: re-estimate unified counterfactual using rho=1.7 instead of rho=1.4
: Note, this is done by MANUALLY CHANGING THE RHO PARAMETER in CF_Skill.gms
gams CF_Skill.gms  --spec=NH  --tradetarg=load --prodtarg=load --demandest=tc

: with NH CES preferences (CLM)

: unified:
gams  CF_Skill_CLM.gms  --spec=NH  --tradetarg=yes --prodtarg=yes --demandest=theta4
gams  CF_Skill_CLM.gms  --spec=H  --tradetarg=yes --prodtarg=yes --demandest=theta4

:goto end

: trade only:
gams CF_Skill_CLM.gms  --spec=NH  --tradetarg=load --prodtarg=no --demandest=theta4  
gams CF_Skill_CLM.gms  --spec=H  --tradetarg=load --prodtarg=no --demandest=theta4

: growth only:
gams CF_Skill_CLM.gms  --spec=NH  --tradetarg=no --prodtarg=load --demandest=theta4
gams CF_Skill_CLM.gms  --spec=H  --tradetarg=no --prodtarg=load --demandest=theta4

: merge results
cd results/SPestimates_tomerge_theta4_CLM
gdxmerge *.gdx
cd../..

:goto end

: with theta = 4

: First, unified
gams  CF_Skill.gms  --spec=NH  --tradetarg=yes --prodtarg=yes --demandest=theta4
gams  CF_Skill.gms  --spec=H  --tradetarg=yes --prodtarg=yes --demandest=theta4

: trade only
gams  CF_Skill.gms  --spec=NH  --tradetarg=load --prodtarg=no --demandest=theta4
gams  CF_Skill.gms  --spec=H  --tradetarg=load --prodtarg=no --demandest=theta4

: then, growth only
gams  CF_Skill.gms  --spec=NH  --tradetarg=no --prodtarg=load --demandest=theta4
gams  CF_Skill.gms  --spec=H  --tradetarg=no --prodtarg=load --demandest=theta4

: merge results
cd results/SPestimates_tomerge_theta4
gdxmerge *.gdx
cd../..


: With heterogenous factor and IO shares (betas)
: Only unified here
gams CF_Skill.gms  --spec=NH  --tradetarg=yes --prodtarg=yes --demandest=tccsbeta
gams CF_Skill.gms  --spec=H  --tradetarg=yes --prodtarg=yes --demandest=tccsbeta




:end